/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.example.email;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.cf.taste.example.email.EmailUtility;
import org.apache.mahout.math.map.OpenObjectIntHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MailToRecMapper
extends Mapper<Text, Text, Text, LongWritable> {
    private static final Logger log = LoggerFactory.getLogger(MailToRecMapper.class);
    private final OpenObjectIntHashMap<String> fromDictionary = new OpenObjectIntHashMap();
    private final OpenObjectIntHashMap<String> msgIdDictionary = new OpenObjectIntHashMap();
    private String separator = "\n";
    private int fromIdx;
    private int refsIdx;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration conf = context.getConfiguration();
        String fromPrefix = conf.get("fromPrefix");
        String msgPrefix = conf.get("msgIdsPrefix");
        this.fromIdx = conf.getInt("fromIdx", 0);
        this.refsIdx = conf.getInt("refsIdx", 1);
        EmailUtility.loadDictionaries(conf, fromPrefix, this.fromDictionary, msgPrefix, this.msgIdDictionary);
        log.info("From Dictionary size: {} Msg Id Dictionary size: {}", (Object)this.fromDictionary.size(), (Object)this.msgIdDictionary.size());
        this.separator = context.getConfiguration().get("separator");
    }

    protected void map(Text key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        String keyStr;
        int idx;
        int msgIdKey = Integer.MIN_VALUE;
        int fromKey = Integer.MIN_VALUE;
        String valStr = value.toString();
        String[] splits = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)valStr, (String)this.separator);
        if (splits != null && splits.length > 0) {
            String[] theRefs;
            if (splits.length > this.refsIdx) {
                String from = EmailUtility.cleanUpEmailAddress(splits[this.fromIdx]);
                fromKey = this.fromDictionary.get((Object)from);
            }
            if (splits.length > this.refsIdx && (theRefs = EmailUtility.parseReferences(splits[this.refsIdx])) != null && theRefs.length > 0) {
                msgIdKey = this.msgIdDictionary.get((Object)theRefs[0]);
                context.getCounter((Enum)Counters.REFERENCE).increment(1L);
            }
        }
        if (msgIdKey == Integer.MIN_VALUE && (idx = (keyStr = key.toString()).lastIndexOf(47)) != -1) {
            String msgId = keyStr.substring(idx + 1);
            msgIdKey = this.msgIdDictionary.get((Object)msgId);
            context.getCounter((Enum)Counters.ORIGINAL).increment(1L);
        }
        if (msgIdKey != Integer.MIN_VALUE && fromKey != Integer.MIN_VALUE) {
            context.write((Object)new Text(fromKey + "," + msgIdKey), (Object)new LongWritable(1L));
        }
    }

    public static enum Counters {
        REFERENCE,
        ORIGINAL;

    }
}

