/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.facet.old.OldFacetsAccumulator;
import org.apache.lucene.facet.params.FacetSearchParams;
import org.apache.lucene.facet.range.RangeAccumulator;
import org.apache.lucene.facet.range.RangeFacetRequest;
import org.apache.lucene.facet.search.FacetArrays;
import org.apache.lucene.facet.search.FacetRequest;
import org.apache.lucene.facet.search.FacetResult;
import org.apache.lucene.facet.search.FacetResultNode;
import org.apache.lucene.facet.search.FacetsCollector;
import org.apache.lucene.facet.search.MultiFacetsAccumulator;
import org.apache.lucene.facet.search.TaxonomyFacetsAccumulator;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesAccumulator;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesReaderState;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.index.IndexReader;

public abstract class FacetsAccumulator {
    public FacetSearchParams searchParams;

    protected FacetsAccumulator(FacetSearchParams fsp) {
        this.searchParams = fsp;
    }

    public static FacetsAccumulator create(FacetSearchParams fsp, IndexReader indexReader, TaxonomyReader taxoReader, FacetArrays arrays) {
        if (fsp.indexingParams.getPartitionSize() != Integer.MAX_VALUE) {
            return new OldFacetsAccumulator(fsp, indexReader, taxoReader, arrays);
        }
        ArrayList<FacetRequest> rangeRequests = new ArrayList<FacetRequest>();
        ArrayList<FacetRequest> nonRangeRequests = new ArrayList<FacetRequest>();
        for (FacetRequest fr : fsp.facetRequests) {
            if (fr instanceof RangeFacetRequest) {
                rangeRequests.add(fr);
                continue;
            }
            nonRangeRequests.add(fr);
        }
        if (rangeRequests.isEmpty()) {
            return new TaxonomyFacetsAccumulator(fsp, indexReader, taxoReader, arrays);
        }
        if (nonRangeRequests.isEmpty()) {
            return new RangeAccumulator(rangeRequests);
        }
        FacetSearchParams searchParams = new FacetSearchParams(fsp.indexingParams, nonRangeRequests);
        TaxonomyFacetsAccumulator accumulator = new TaxonomyFacetsAccumulator(searchParams, indexReader, taxoReader, arrays);
        RangeAccumulator rangeAccumulator = new RangeAccumulator(rangeRequests);
        return MultiFacetsAccumulator.wrap(accumulator, rangeAccumulator);
    }

    public static FacetsAccumulator create(FacetSearchParams fsp, SortedSetDocValuesReaderState state, FacetArrays arrays) throws IOException {
        if (fsp.indexingParams.getPartitionSize() != Integer.MAX_VALUE) {
            throw new IllegalArgumentException("only default partition size is supported by this method: " + fsp.indexingParams.getPartitionSize());
        }
        ArrayList<FacetRequest> rangeRequests = new ArrayList<FacetRequest>();
        ArrayList<FacetRequest> nonRangeRequests = new ArrayList<FacetRequest>();
        for (FacetRequest fr : fsp.facetRequests) {
            if (fr instanceof RangeFacetRequest) {
                rangeRequests.add(fr);
                continue;
            }
            nonRangeRequests.add(fr);
        }
        if (rangeRequests.isEmpty()) {
            return new SortedSetDocValuesAccumulator(state, fsp, arrays);
        }
        if (nonRangeRequests.isEmpty()) {
            return new RangeAccumulator(rangeRequests);
        }
        FacetSearchParams searchParams = new FacetSearchParams(fsp.indexingParams, nonRangeRequests);
        SortedSetDocValuesAccumulator accumulator = new SortedSetDocValuesAccumulator(state, searchParams, arrays);
        RangeAccumulator rangeAccumulator = new RangeAccumulator(rangeRequests);
        return MultiFacetsAccumulator.wrap(accumulator, rangeAccumulator);
    }

    protected static FacetResult emptyResult(int ordinal, FacetRequest fr) {
        FacetResultNode root = new FacetResultNode(ordinal, 0.0);
        root.label = fr.categoryPath;
        return new FacetResult(fr, root, 0);
    }

    public abstract List<FacetResult> accumulate(List<FacetsCollector.MatchingDocs> var1) throws IOException;

    public abstract boolean requiresDocScores();
}

