/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import org.apache.lucene.facet.params.CategoryListParams;
import org.apache.lucene.facet.search.FacetArrays;
import org.apache.lucene.facet.search.FacetsCollector;
import org.apache.lucene.facet.search.IntRollupFacetsAggregator;
import org.apache.lucene.facet.search.OrdinalsCache;

public class CachedOrdsCountingFacetsAggregator
extends IntRollupFacetsAggregator {
    @Override
    public void aggregate(FacetsCollector.MatchingDocs matchingDocs, CategoryListParams clp, FacetArrays facetArrays) throws IOException {
        OrdinalsCache.CachedOrds ords = OrdinalsCache.getCachedOrds(matchingDocs.context, clp);
        if (ords == null) {
            return;
        }
        int[] counts = facetArrays.getIntArray();
        int length = matchingDocs.bits.length();
        for (int doc = 0; doc < length && (doc = matchingDocs.bits.nextSetBit(doc)) != -1; ++doc) {
            int start = ords.offsets[doc];
            int end = ords.offsets[doc + 1];
            for (int i = start; i < end; ++i) {
                int n = ords.ordinals[i];
                counts[n] = counts[n] + 1;
            }
        }
    }
}

