/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.associations;

import java.io.IOException;
import org.apache.lucene.facet.params.CategoryListParams;
import org.apache.lucene.facet.search.FacetArrays;
import org.apache.lucene.facet.search.FacetRequest;
import org.apache.lucene.facet.search.FacetsAggregator;
import org.apache.lucene.facet.search.FacetsCollector;
import org.apache.lucene.facet.search.OrdinalValueResolver;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.util.BytesRef;

public class SumFloatAssociationFacetsAggregator
implements FacetsAggregator {
    private final BytesRef bytes = new BytesRef(32);

    @Override
    public void aggregate(FacetsCollector.MatchingDocs matchingDocs, CategoryListParams clp, FacetArrays facetArrays) throws IOException {
        BinaryDocValues dv = matchingDocs.context.reader().getBinaryDocValues(clp.field + "$assoc_float$");
        if (dv == null) {
            return;
        }
        int length = matchingDocs.bits.length();
        float[] values = facetArrays.getFloatArray();
        for (int doc = 0; doc < length && (doc = matchingDocs.bits.nextSetBit(doc)) != -1; ++doc) {
            dv.get(doc, this.bytes);
            if (this.bytes.length <= 0) continue;
            int bytesUpto = this.bytes.offset + this.bytes.length;
            int pos = this.bytes.offset;
            while (pos < bytesUpto) {
                int ordinal = (this.bytes.bytes[pos++] & 0xFF) << 24 | (this.bytes.bytes[pos++] & 0xFF) << 16 | (this.bytes.bytes[pos++] & 0xFF) << 8 | this.bytes.bytes[pos++] & 0xFF;
                int value = (this.bytes.bytes[pos++] & 0xFF) << 24 | (this.bytes.bytes[pos++] & 0xFF) << 16 | (this.bytes.bytes[pos++] & 0xFF) << 8 | this.bytes.bytes[pos++] & 0xFF;
                int n = ordinal;
                values[n] = values[n] + Float.intBitsToFloat(value);
            }
        }
    }

    @Override
    public boolean requiresDocScores() {
        return false;
    }

    @Override
    public void rollupValues(FacetRequest fr, int ordinal, int[] children, int[] siblings, FacetArrays facetArrays) {
    }

    @Override
    public OrdinalValueResolver createOrdinalValueResolver(FacetRequest facetRequest, FacetArrays arrays) {
        return new OrdinalValueResolver.FloatValueResolver(arrays);
    }
}

