/*
 * Decompiled with CFR 0.152.
 */
package org.easymock;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.easymock.ConstructorArgs;
import org.easymock.EasyMock;
import org.easymock.IMockBuilder;
import org.easymock.IMocksControl;
import org.easymock.Mock;
import org.easymock.MockType;
import org.easymock.TestSubject;
import org.easymock.internal.MockBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasyMockSupport {
    protected final List<IMocksControl> controls = new ArrayList<IMocksControl>(5);

    @Deprecated
    public <T> T createStrictMock(Class<T> toMock, Method ... mockedMethods) {
        return this.createStrictControl().createMock(toMock, mockedMethods);
    }

    @Deprecated
    public <T> T createStrictMock(String name, Class<T> toMock, Method ... mockedMethods) {
        return this.createStrictControl().createMock(name, toMock, mockedMethods);
    }

    @Deprecated
    public <T> T createStrictMock(Class<T> toMock, ConstructorArgs constructorArgs, Method ... mockedMethods) {
        return this.createStrictControl().createMock(toMock, constructorArgs, mockedMethods);
    }

    @Deprecated
    public <T> T createStrictMock(String name, Class<T> toMock, ConstructorArgs constructorArgs, Method ... mockedMethods) {
        return this.createStrictControl().createMock(name, toMock, constructorArgs, mockedMethods);
    }

    @Deprecated
    public <T> T createMock(Class<T> toMock, Method ... mockedMethods) {
        return this.createControl().createMock(toMock, mockedMethods);
    }

    @Deprecated
    public <T> T createMock(String name, Class<T> toMock, Method ... mockedMethods) {
        return this.createControl().createMock(name, toMock, mockedMethods);
    }

    @Deprecated
    public <T> T createMock(Class<T> toMock, ConstructorArgs constructorArgs, Method ... mockedMethods) {
        return this.createControl().createMock(toMock, constructorArgs, mockedMethods);
    }

    @Deprecated
    public <T> T createMock(String name, Class<T> toMock, ConstructorArgs constructorArgs, Method ... mockedMethods) {
        return this.createControl().createMock(name, toMock, constructorArgs, mockedMethods);
    }

    @Deprecated
    public <T> T createNiceMock(Class<T> toMock, Method ... mockedMethods) {
        return this.createNiceControl().createMock(toMock, mockedMethods);
    }

    @Deprecated
    public <T> T createNiceMock(String name, Class<T> toMock, Method ... mockedMethods) {
        return this.createNiceControl().createMock(name, toMock, mockedMethods);
    }

    @Deprecated
    public <T> T createNiceMock(Class<T> toMock, ConstructorArgs constructorArgs, Method ... mockedMethods) {
        return this.createNiceControl().createMock(toMock, constructorArgs, mockedMethods);
    }

    @Deprecated
    public <T> T createNiceMock(String name, Class<T> toMock, ConstructorArgs constructorArgs, Method ... mockedMethods) {
        return this.createNiceControl().createMock(name, toMock, constructorArgs, mockedMethods);
    }

    public <T> T createMock(MockType type, Class<T> toMock) {
        return this.createControl(type).createMock(toMock);
    }

    public <T> T createMock(String name, MockType type, Class<T> toMock) {
        return this.createControl(type).createMock(name, toMock);
    }

    public <T> T createStrictMock(Class<T> toMock) {
        return this.createStrictControl().createMock(toMock);
    }

    public <T> T createStrictMock(String name, Class<T> toMock) {
        return this.createStrictControl().createMock(name, toMock);
    }

    public <T> T createMock(Class<T> toMock) {
        return this.createControl().createMock(toMock);
    }

    public <T> T createMock(String name, Class<T> toMock) {
        return this.createControl().createMock(name, toMock);
    }

    public <T> T createNiceMock(Class<T> toMock) {
        return this.createNiceControl().createMock(toMock);
    }

    public <T> T createNiceMock(String name, Class<T> toMock) {
        return this.createNiceControl().createMock(name, toMock);
    }

    public IMocksControl createStrictControl() {
        IMocksControl ctrl = EasyMock.createStrictControl();
        this.controls.add(ctrl);
        return ctrl;
    }

    public <T> IMockBuilder<T> createMockBuilder(Class<T> toMock) {
        return new MockBuilder<T>(toMock, this);
    }

    public IMocksControl createControl(MockType type) {
        IMocksControl ctrl = EasyMock.createControl(type);
        this.controls.add(ctrl);
        return ctrl;
    }

    public IMocksControl createControl() {
        return this.createControl(MockType.DEFAULT);
    }

    public IMocksControl createNiceControl() {
        IMocksControl ctrl = EasyMock.createNiceControl();
        this.controls.add(ctrl);
        return ctrl;
    }

    public void replayAll() {
        for (IMocksControl c : this.controls) {
            c.replay();
        }
    }

    public void resetAll() {
        for (IMocksControl c : this.controls) {
            c.reset();
        }
    }

    public void verifyAll() {
        for (IMocksControl c : this.controls) {
            c.verify();
        }
    }

    public void resetAllToNice() {
        for (IMocksControl c : this.controls) {
            c.resetToNice();
        }
    }

    public void resetAllToDefault() {
        for (IMocksControl c : this.controls) {
            c.resetToDefault();
        }
    }

    public void resetAllToStrict() {
        for (IMocksControl c : this.controls) {
            c.resetToStrict();
        }
    }

    public static void injectMocks(Object obj) {
        Class<?> c;
        ArrayList<Field> injectMockFields = new ArrayList<Field>(1);
        ArrayList<Object> mocks = new ArrayList<Object>(5);
        for (c = obj.getClass(); c != Object.class; c = c.getSuperclass()) {
            EasyMockSupport.createMocksForAnnotations(c, obj, mocks, injectMockFields);
        }
        for (Field f : injectMockFields) {
            Object o;
            f.setAccessible(true);
            try {
                o = f.get(obj);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            for (c = o.getClass(); c != Object.class; c = c.getSuperclass()) {
                EasyMockSupport.injectMocksOnClass(c, o, mocks);
            }
        }
    }

    private static void injectMocksOnClass(Class<?> clazz, Object obj, List<Object> mocks) {
        Field[] fields;
        for (Field f : fields = clazz.getDeclaredFields()) {
            if ((f.getModifiers() & 0x18) != 0) continue;
            Class<?> type = f.getType();
            Object toAssign = null;
            for (Object mock : mocks) {
                if (!type.isAssignableFrom(mock.getClass())) continue;
                if (toAssign != null) {
                    throw new RuntimeException("At least two mocks can be assigned to " + f + ": " + toAssign + " and " + mock);
                }
                toAssign = mock;
            }
            if (toAssign == null) continue;
            f.setAccessible(true);
            try {
                f.set(obj, toAssign);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void createMocksForAnnotations(Class<?> clazz, Object obj, List<Object> mocks, List<Field> injectMockFields) {
        Field[] fields;
        for (Field f : fields = clazz.getDeclaredFields()) {
            TestSubject ima = f.getAnnotation(TestSubject.class);
            if (ima != null) {
                injectMockFields.add(f);
                continue;
            }
            Mock annotation = f.getAnnotation(Mock.class);
            if (annotation == null) continue;
            Class<?> type = f.getType();
            String name = annotation.name();
            name = name.length() == 0 ? null : name;
            MockType mockType = annotation.type();
            Object o = obj instanceof EasyMockSupport ? ((EasyMockSupport)obj).createMock(name, mockType, type) : EasyMock.createMock(name, mockType, type);
            f.setAccessible(true);
            try {
                f.set(obj, o);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            mocks.add(o);
        }
    }
}

