/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.neighborhood;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.util.PriorityQueue;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.math.MatrixSlice;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.WeightedVector;
import org.apache.mahout.math.random.WeightedThing;

public abstract class Searcher
implements Iterable<Vector> {
    protected DistanceMeasure distanceMeasure;

    protected Searcher(DistanceMeasure distanceMeasure) {
        this.distanceMeasure = distanceMeasure;
    }

    public DistanceMeasure getDistanceMeasure() {
        return this.distanceMeasure;
    }

    public abstract void add(Vector var1);

    public abstract int size();

    public abstract List<WeightedThing<Vector>> search(Vector var1, int var2);

    public List<List<WeightedThing<Vector>>> search(Iterable<? extends Vector> queries, int limit) {
        ArrayList<List<WeightedThing<Vector>>> results = Lists.newArrayListWithExpectedSize(Iterables.size(queries));
        for (Vector vector : queries) {
            results.add(this.search(vector, limit));
        }
        return results;
    }

    public abstract WeightedThing<Vector> searchFirst(Vector var1, boolean var2);

    public List<WeightedThing<Vector>> searchFirst(Iterable<? extends Vector> queries, boolean differentThanQuery) {
        ArrayList<WeightedThing<Vector>> results = Lists.newArrayListWithExpectedSize(Iterables.size(queries));
        for (Vector vector : queries) {
            results.add(this.searchFirst(vector, differentThanQuery));
        }
        return results;
    }

    public void addAll(Iterable<? extends Vector> data) {
        for (Vector vector : data) {
            this.add(vector);
        }
    }

    public void addAllMatrixSlices(Iterable<MatrixSlice> data) {
        for (MatrixSlice slice : data) {
            this.add(slice.vector());
        }
    }

    public void addAllMatrixSlicesAsWeightedVectors(Iterable<MatrixSlice> data) {
        for (MatrixSlice slice : data) {
            this.add(new WeightedVector(slice.vector(), 1.0, slice.index()));
        }
    }

    public boolean remove(Vector v, double epsilon) {
        throw new UnsupportedOperationException("Can't remove a vector from a " + this.getClass().getName());
    }

    public void clear() {
        throw new UnsupportedOperationException("Can't remove vectors from a " + this.getClass().getName());
    }

    public static PriorityQueue<WeightedThing<Vector>> getCandidateQueue(int limit) {
        return new PriorityQueue<WeightedThing<Vector>>(limit){

            @Override
            protected boolean lessThan(WeightedThing<Vector> a, WeightedThing<Vector> b) {
                return a.getWeight() > b.getWeight();
            }
        };
    }
}

