/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.stochasticsvd;

import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.util.Deque;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.lib.MultipleOutputs;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.mahout.common.IOUtils;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.hadoop.stochasticsvd.DenseBlockWritable;
import org.apache.mahout.math.hadoop.stochasticsvd.Omega;
import org.apache.mahout.math.hadoop.stochasticsvd.SSVDHelper;
import org.apache.mahout.math.hadoop.stochasticsvd.SplitPartitionedWritable;
import org.apache.mahout.math.hadoop.stochasticsvd.qr.QRFirstStep;

public final class QJob {
    public static final String PROP_OMEGA_SEED = "ssvd.omegaseed";
    public static final String PROP_K = "ssvd.k";
    public static final String PROP_P = "ssvd.p";
    public static final String PROP_SB_PATH = "ssvdpca.sb.path";
    public static final String PROP_AROWBLOCK_SIZE = "ssvd.arowblock.size";
    public static final String OUTPUT_RHAT = "R";
    public static final String OUTPUT_QHAT = "QHat";

    private QJob() {
    }

    public static void run(Configuration conf, Path[] inputPaths, Path sbPath, Path outputPath, int aBlockRows, int minSplitSize, int k, int p, long seed, int numReduceTasks) throws ClassNotFoundException, InterruptedException, IOException {
        JobConf oldApiJob = new JobConf(conf);
        MultipleOutputs.addNamedOutput((JobConf)oldApiJob, (String)OUTPUT_QHAT, org.apache.hadoop.mapred.SequenceFileOutputFormat.class, SplitPartitionedWritable.class, DenseBlockWritable.class);
        MultipleOutputs.addNamedOutput((JobConf)oldApiJob, (String)OUTPUT_RHAT, org.apache.hadoop.mapred.SequenceFileOutputFormat.class, SplitPartitionedWritable.class, VectorWritable.class);
        Job job = new Job((Configuration)oldApiJob);
        job.setJobName("Q-job");
        job.setJarByClass(QJob.class);
        job.setInputFormatClass(SequenceFileInputFormat.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])inputPaths);
        if (minSplitSize > 0) {
            FileInputFormat.setMinInputSplitSize((Job)job, (long)minSplitSize);
        }
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        FileOutputFormat.setCompressOutput((Job)job, (boolean)true);
        FileOutputFormat.setOutputCompressorClass((Job)job, DefaultCodec.class);
        SequenceFileOutputFormat.setOutputCompressionType((Job)job, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK);
        job.setMapOutputKeyClass(SplitPartitionedWritable.class);
        job.setMapOutputValueClass(VectorWritable.class);
        job.setOutputKeyClass(SplitPartitionedWritable.class);
        job.setOutputValueClass(VectorWritable.class);
        job.setMapperClass(QMapper.class);
        job.getConfiguration().setInt(PROP_AROWBLOCK_SIZE, aBlockRows);
        job.getConfiguration().setLong(PROP_OMEGA_SEED, seed);
        job.getConfiguration().setInt(PROP_K, k);
        job.getConfiguration().setInt(PROP_P, p);
        if (sbPath != null) {
            job.getConfiguration().set(PROP_SB_PATH, sbPath.toString());
        }
        job.setNumReduceTasks(0);
        job.submit();
        job.waitForCompletion(false);
        if (!job.isSuccessful()) {
            throw new IOException("Q job unsuccessful.");
        }
    }

    public static class QMapper
    extends Mapper<Writable, VectorWritable, SplitPartitionedWritable, VectorWritable> {
        private MultipleOutputs outputs;
        private final Deque<Closeable> closeables = Lists.newLinkedList();
        private SplitPartitionedWritable qHatKey;
        private SplitPartitionedWritable rHatKey;
        private Vector yRow;
        private Vector sb;
        private Omega omega;
        private int kp;
        private QRFirstStep qr;

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            Configuration conf = context.getConfiguration();
            int k = Integer.parseInt(conf.get(QJob.PROP_K));
            int p = Integer.parseInt(conf.get(QJob.PROP_P));
            this.kp = k + p;
            long omegaSeed = Long.parseLong(conf.get(QJob.PROP_OMEGA_SEED));
            this.omega = new Omega(omegaSeed, k + p);
            String sbPathStr = conf.get(QJob.PROP_SB_PATH);
            if (sbPathStr != null) {
                this.sb = SSVDHelper.loadAndSumUpVectors(new Path(sbPathStr), conf);
                if (this.sb == null) {
                    throw new IOException(String.format("Unable to load s_omega from path %s.", sbPathStr));
                }
            }
            this.outputs = new MultipleOutputs(new JobConf(conf));
            this.closeables.addFirst(new Closeable(){

                @Override
                public void close() throws IOException {
                    QMapper.this.outputs.close();
                }
            });
            this.qHatKey = new SplitPartitionedWritable(context);
            this.rHatKey = new SplitPartitionedWritable(context);
            OutputCollector<Writable, DenseBlockWritable> qhatCollector = new OutputCollector<Writable, DenseBlockWritable>(){

                public void collect(Writable nil, DenseBlockWritable dbw) throws IOException {
                    QMapper.this.outputs.getCollector(QJob.OUTPUT_QHAT, null).collect((Object)QMapper.this.qHatKey, (Object)dbw);
                    QMapper.this.qHatKey.incrementItemOrdinal();
                }
            };
            OutputCollector<Writable, VectorWritable> rhatCollector = new OutputCollector<Writable, VectorWritable>(){

                public void collect(Writable nil, VectorWritable rhat) throws IOException {
                    QMapper.this.outputs.getCollector(QJob.OUTPUT_RHAT, null).collect((Object)QMapper.this.rHatKey, (Object)rhat);
                    QMapper.this.rHatKey.incrementItemOrdinal();
                }
            };
            this.qr = new QRFirstStep(conf, (OutputCollector<? super Writable, ? super DenseBlockWritable>)qhatCollector, (OutputCollector<? super Writable, ? super VectorWritable>)rhatCollector);
            this.closeables.addFirst(this.qr);
            this.yRow = new DenseVector(this.kp);
        }

        protected void map(Writable key, VectorWritable value, Mapper.Context context) throws IOException, InterruptedException {
            this.omega.computeYRow(value.get(), this.yRow);
            if (this.sb != null) {
                this.yRow.assign(this.sb, Functions.MINUS);
            }
            this.qr.collect(key, this.yRow);
        }

        protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            IOUtils.close(this.closeables);
        }
    }
}

