/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.fpm.pfpgrowth.fpgrowth;

import com.google.common.collect.Sets;
import java.util.PriorityQueue;
import java.util.Set;
import org.apache.mahout.fpm.pfpgrowth.fpgrowth.Pattern;
import org.apache.mahout.math.map.OpenLongObjectHashMap;

public final class FrequentPatternMaxHeap {
    private int count;
    private Pattern least;
    private final int maxSize;
    private final boolean subPatternCheck;
    private final OpenLongObjectHashMap<Set<Pattern>> patternIndex;
    private final PriorityQueue<Pattern> queue;

    public FrequentPatternMaxHeap(int numResults, boolean subPatternCheck) {
        this.maxSize = numResults;
        this.queue = new PriorityQueue(this.maxSize);
        this.subPatternCheck = subPatternCheck;
        this.patternIndex = new OpenLongObjectHashMap();
        for (Pattern p : this.queue) {
            Set<Object> patternList;
            Long index = p.support();
            if (!this.patternIndex.containsKey(index)) {
                patternList = Sets.newHashSet();
                this.patternIndex.put(index, patternList);
            }
            patternList = this.patternIndex.get(index);
            patternList.add(p);
        }
    }

    public boolean addable(long support) {
        return this.count < this.maxSize || this.least.support() <= support;
    }

    public PriorityQueue<Pattern> getHeap() {
        if (this.subPatternCheck) {
            PriorityQueue<Pattern> ret = new PriorityQueue<Pattern>(this.maxSize);
            for (Pattern p : this.queue) {
                if (!this.patternIndex.get(p.support()).contains(p)) continue;
                ret.add(p);
            }
            return ret;
        }
        return this.queue;
    }

    public void addAll(FrequentPatternMaxHeap patterns, int attribute, long attributeSupport) {
        for (Pattern pattern : patterns.getHeap()) {
            long support = Math.min(attributeSupport, pattern.support());
            if (!this.addable(support)) continue;
            pattern.add(attribute, support);
            this.insert(pattern);
        }
    }

    public void insert(Pattern frequentPattern) {
        if (frequentPattern.length() == 0) {
            return;
        }
        if (this.count == this.maxSize) {
            if (frequentPattern.compareTo(this.least) > 0 && this.addPattern(frequentPattern)) {
                Pattern evictedItem = this.queue.poll();
                this.least = this.queue.peek();
                if (this.subPatternCheck) {
                    this.patternIndex.get(evictedItem.support()).remove(evictedItem);
                }
            }
        } else if (this.addPattern(frequentPattern)) {
            ++this.count;
            if (this.least == null) {
                this.least = frequentPattern;
            } else if (this.least.compareTo(frequentPattern) < 0) {
                this.least = frequentPattern;
            }
        }
    }

    public int count() {
        return this.count;
    }

    public boolean isFull() {
        return this.count == this.maxSize;
    }

    public long leastSupport() {
        if (this.least == null) {
            return 0L;
        }
        return this.least.support();
    }

    private boolean addPattern(Pattern frequentPattern) {
        if (this.subPatternCheck) {
            Long index = frequentPattern.support();
            if (this.patternIndex.containsKey(index)) {
                Set<Pattern> indexSet = this.patternIndex.get(index);
                boolean replace = false;
                Pattern replacablePattern = null;
                for (Pattern p : indexSet) {
                    if (frequentPattern.isSubPatternOf(p)) {
                        return false;
                    }
                    if (!p.isSubPatternOf(frequentPattern)) continue;
                    replace = true;
                    replacablePattern = p;
                    break;
                }
                if (replace) {
                    indexSet.remove(replacablePattern);
                    if (!indexSet.contains(frequentPattern) && this.queue.add(frequentPattern)) {
                        indexSet.add(frequentPattern);
                    }
                    return false;
                }
                this.queue.add(frequentPattern);
                indexSet.add(frequentPattern);
            } else {
                Set<Object> patternList;
                this.queue.add(frequentPattern);
                if (!this.patternIndex.containsKey(index)) {
                    patternList = Sets.newHashSet();
                    this.patternIndex.put(index, patternList);
                }
                patternList = this.patternIndex.get(index);
                patternList.add(frequentPattern);
            }
        } else {
            this.queue.add(frequentPattern);
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FreqPatHeap{");
        String sep = "";
        for (Pattern p : this.getHeap()) {
            sb.append(sep).append(p);
            sep = ", ";
        }
        return sb.toString();
    }
}

