/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DefaultStringifier;
import org.apache.hadoop.util.GenericsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parameters {
    private static final Logger log = LoggerFactory.getLogger(Parameters.class);
    private Map<String, String> params = Maps.newHashMap();

    public Parameters() {
    }

    public Parameters(String serializedString) throws IOException {
        this(Parameters.parseParams(serializedString));
    }

    protected Parameters(Map<String, String> params) {
        this.params = params;
    }

    public String get(String key) {
        return this.params.get(key);
    }

    public String get(String key, String defaultValue) {
        String ret = this.params.get(key);
        return ret == null ? defaultValue : ret;
    }

    public void set(String key, String value) {
        this.params.put(key, value);
    }

    public int getInt(String key, int defaultValue) {
        String ret = this.params.get(key);
        return ret == null ? defaultValue : Integer.parseInt(ret);
    }

    public String toString() {
        Configuration conf = new Configuration();
        conf.set("io.serializations", "org.apache.hadoop.io.serializer.JavaSerialization,org.apache.hadoop.io.serializer.WritableSerialization");
        DefaultStringifier mapStringifier = new DefaultStringifier(conf, GenericsUtil.getClass(this.params));
        try {
            return mapStringifier.toString(this.params);
        }
        catch (IOException e) {
            log.info("Encountered IOException while deserializing returning empty string", (Throwable)e);
            return "";
        }
    }

    public String print() {
        return this.params.toString();
    }

    public static Map<String, String> parseParams(String serializedString) throws IOException {
        Configuration conf = new Configuration();
        conf.set("io.serializations", "org.apache.hadoop.io.serializer.JavaSerialization,org.apache.hadoop.io.serializer.WritableSerialization");
        HashMap params = Maps.newHashMap();
        DefaultStringifier mapStringifier = new DefaultStringifier(conf, GenericsUtil.getClass(params));
        return (Map)mapStringifier.fromString(serializedString);
    }
}

