/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.topdown;

import java.io.File;
import org.apache.hadoop.fs.Path;

public final class PathDirectory {
    public static final String TOP_LEVEL_CLUSTER_DIRECTORY = "topLevelCluster";
    public static final String POST_PROCESS_DIRECTORY = "clusterPostProcessed";
    public static final String CLUSTERED_POINTS_DIRECTORY = "clusteredPoints";
    public static final String BOTTOM_LEVEL_CLUSTER_DIRECTORY = "bottomLevelCluster";

    private PathDirectory() {
    }

    public static Path getTopLevelClusterPath(Path output) {
        return new Path(output + File.separator + TOP_LEVEL_CLUSTER_DIRECTORY);
    }

    public static Path getClusterPostProcessorOutputDirectory(Path outputPathProvidedByUser) {
        return new Path(outputPathProvidedByUser + File.separator + POST_PROCESS_DIRECTORY);
    }

    public static Path getClusterOutputClusteredPoints(Path output) {
        return new Path(output + File.separator + CLUSTERED_POINTS_DIRECTORY + File.separator, "*");
    }

    public static Path getBottomLevelClusterPath(Path output, String clusterId) {
        return new Path(output + File.separator + BOTTOM_LEVEL_CLUSTER_DIRECTORY + File.separator + clusterId);
    }

    public static Path getClusterPathForClusterId(Path clusterPostProcessorOutput, String clusterId) {
        return new Path(clusterPostProcessorOutput + File.separator + clusterId);
    }
}

