/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.spectral;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileValueIterator;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VectorCache {
    private static final Logger log = LoggerFactory.getLogger(VectorCache.class);

    private VectorCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(Writable key, Vector vector, Path output, Configuration conf, boolean overwritePath, boolean deleteOnExit) throws IOException {
        FileSystem fs = FileSystem.get((URI)output.toUri(), (Configuration)conf);
        output = fs.makeQualified(output);
        if (overwritePath) {
            HadoopUtil.delete(conf, output);
        }
        DistributedCache.setCacheFiles((URI[])new URI[]{output.toUri()}, (Configuration)conf);
        SequenceFile.Writer writer = new SequenceFile.Writer(fs, conf, output, IntWritable.class, VectorWritable.class);
        try {
            writer.append(key, (Writable)new VectorWritable(vector));
        }
        finally {
            Closeables.close((Closeable)writer, false);
        }
        if (deleteOnExit) {
            fs.deleteOnExit(output);
        }
    }

    public static void save(Writable key, Vector vector, Path output, Configuration conf) throws IOException {
        VectorCache.save(key, vector, output, conf, true, true);
    }

    public static Vector load(Configuration conf) throws IOException {
        Object[] files = HadoopUtil.getCachedFiles(conf);
        if (files.length != 1) {
            throw new IOException("Cannot read Frequency list from Distributed Cache (" + files.length + ')');
        }
        if (log.isInfoEnabled()) {
            log.info("Files are: {}", (Object)Arrays.toString(files));
        }
        return VectorCache.load(conf, (Path)files[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector load(Configuration conf, Path input) throws IOException {
        log.info("Loading vector from: {}", (Object)input);
        SequenceFileValueIterator iterator = new SequenceFileValueIterator(input, true, conf);
        try {
            Vector vector = ((VectorWritable)((Object)iterator.next())).get();
            return vector;
        }
        finally {
            Closeables.close(iterator, true);
        }
    }
}

