/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.evaluation;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.clustering.classify.WeightedVectorWritable;
import org.apache.mahout.common.ClassUtils;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.distance.EuclideanDistanceMeasure;
import org.apache.mahout.common.iterator.sequencefile.PathFilters;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirIterable;
import org.apache.mahout.math.VectorWritable;

public class RepresentativePointsMapper
extends Mapper<IntWritable, WeightedVectorWritable, IntWritable, WeightedVectorWritable> {
    private Map<Integer, List<VectorWritable>> representativePoints;
    private final Map<Integer, WeightedVectorWritable> mostDistantPoints = Maps.newHashMap();
    private DistanceMeasure measure = new EuclideanDistanceMeasure();

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        for (Map.Entry<Integer, WeightedVectorWritable> entry : this.mostDistantPoints.entrySet()) {
            context.write((Object)new IntWritable(entry.getKey().intValue()), (Object)entry.getValue());
        }
        super.cleanup(context);
    }

    protected void map(IntWritable clusterId, WeightedVectorWritable point, Mapper.Context context) throws IOException, InterruptedException {
        RepresentativePointsMapper.mapPoint(clusterId, point, this.measure, this.representativePoints, this.mostDistantPoints);
    }

    public static void mapPoint(IntWritable clusterId, WeightedVectorWritable point, DistanceMeasure measure, Map<Integer, List<VectorWritable>> representativePoints, Map<Integer, WeightedVectorWritable> mostDistantPoints) {
        int key = clusterId.get();
        WeightedVectorWritable currentMDP = mostDistantPoints.get(key);
        List<VectorWritable> repPoints = representativePoints.get(key);
        double totalDistance = 0.0;
        if (repPoints != null) {
            for (VectorWritable refPoint : repPoints) {
                totalDistance += measure.distance(refPoint.get(), point.getVector());
            }
        }
        if (currentMDP == null || currentMDP.getWeight() < totalDistance) {
            mostDistantPoints.put(key, new WeightedVectorWritable(totalDistance, point.getVector().clone()));
        }
    }

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration conf = context.getConfiguration();
        this.measure = ClassUtils.instantiateAs(conf.get("org.apache.mahout.clustering.measure"), DistanceMeasure.class);
        this.representativePoints = RepresentativePointsMapper.getRepresentativePoints(conf);
    }

    public void configure(Map<Integer, List<VectorWritable>> referencePoints, DistanceMeasure measure) {
        this.representativePoints = referencePoints;
        this.measure = measure;
    }

    public static Map<Integer, List<VectorWritable>> getRepresentativePoints(Configuration conf) {
        String statePath = conf.get("org.apache.mahout.clustering.stateIn");
        return RepresentativePointsMapper.getRepresentativePoints(conf, new Path(statePath));
    }

    public static Map<Integer, List<VectorWritable>> getRepresentativePoints(Configuration conf, Path statePath) {
        HashMap<Integer, List<VectorWritable>> representativePoints = Maps.newHashMap();
        for (Pair record : new SequenceFileDirIterable(statePath, PathType.LIST, PathFilters.logsCRCFilter(), conf)) {
            int keyValue = ((IntWritable)record.getFirst()).get();
            ArrayList repPoints = (ArrayList)representativePoints.get(keyValue);
            if (repPoints == null) {
                repPoints = Lists.newArrayList();
                representativePoints.put(keyValue, repPoints);
            }
            repPoints.add(record.getSecond());
        }
        return representativePoints;
    }
}

