/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.display;

import com.google.common.collect.Lists;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.clustering.Cluster;
import org.apache.mahout.clustering.classify.ClusterClassifier;
import org.apache.mahout.clustering.display.DisplayClustering;
import org.apache.mahout.clustering.iterator.ClusterIterator;
import org.apache.mahout.clustering.iterator.KMeansClusteringPolicy;
import org.apache.mahout.clustering.kmeans.KMeansDriver;
import org.apache.mahout.clustering.kmeans.Kluster;
import org.apache.mahout.clustering.kmeans.RandomSeedGenerator;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.distance.ManhattanDistanceMeasure;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class DisplayKMeans
extends DisplayClustering {
    DisplayKMeans() {
        this.initialize();
        this.setTitle("k-Means Clusters (>" + (int)(significance * 100.0) + "% of population)");
    }

    public static void main(String[] args) throws Exception {
        ManhattanDistanceMeasure measure = new ManhattanDistanceMeasure();
        Path samples = new Path("samples");
        Path output = new Path("output");
        Configuration conf = new Configuration();
        HadoopUtil.delete(conf, samples);
        HadoopUtil.delete(conf, output);
        RandomUtils.useTestSeed();
        DisplayKMeans.generateSamples();
        DisplayKMeans.writeSampleData(samples);
        boolean runClusterer = true;
        double convergenceDelta = 0.001;
        int numClusters = 3;
        int maxIterations = 10;
        if (runClusterer) {
            DisplayKMeans.runSequentialKMeansClusterer(conf, samples, output, measure, numClusters, maxIterations, convergenceDelta);
        } else {
            DisplayKMeans.runSequentialKMeansClassifier(conf, samples, output, measure, numClusters, maxIterations, convergenceDelta);
        }
        new DisplayKMeans();
    }

    private static void runSequentialKMeansClassifier(Configuration conf, Path samples, Path output, DistanceMeasure measure, int numClusters, int maxIterations, double convergenceDelta) throws IOException {
        ArrayList<Vector> points = Lists.newArrayList();
        for (int i = 0; i < numClusters; ++i) {
            points.add(((VectorWritable)((Object)SAMPLE_DATA.get(i))).get());
        }
        ArrayList<Cluster> initialClusters = Lists.newArrayList();
        int id = 0;
        for (Vector point : points) {
            initialClusters.add(new Kluster(point, id++, measure));
        }
        ClusterClassifier prior = new ClusterClassifier(initialClusters, new KMeansClusteringPolicy(convergenceDelta));
        Path priorPath = new Path(output, "clusters-0");
        prior.writeToSeqFiles(priorPath);
        ClusterIterator.iterateSeq(conf, samples, priorPath, output, maxIterations);
        DisplayKMeans.loadClustersWritable(output);
    }

    private static void runSequentialKMeansClusterer(Configuration conf, Path samples, Path output, DistanceMeasure measure, int numClusters, int maxIterations, double convergenceDelta) throws IOException, InterruptedException, ClassNotFoundException {
        Path clustersIn = new Path(output, "random-seeds");
        RandomSeedGenerator.buildRandom(conf, samples, clustersIn, numClusters, measure);
        KMeansDriver.run(samples, clustersIn, output, convergenceDelta, maxIterations, true, 0.0, true);
        DisplayKMeans.loadClustersWritable(output);
    }

    @Override
    public void paint(Graphics g) {
        DisplayKMeans.plotSampleData((Graphics2D)g);
        DisplayKMeans.plotClusters((Graphics2D)g);
    }
}

