/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.example.kddcup.track1;

import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.mahout.cf.taste.example.kddcup.DataFileIterable;
import org.apache.mahout.cf.taste.example.kddcup.KDDCupDataModel;
import org.apache.mahout.cf.taste.example.kddcup.track1.Track1Callable;
import org.apache.mahout.cf.taste.example.kddcup.track1.Track1Recommender;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.common.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Track1Runner {
    private static final Logger log = LoggerFactory.getLogger(Track1Runner.class);

    private Track1Runner() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        File dataFileDirectory = new File(args[0]);
        if (!dataFileDirectory.exists() || !dataFileDirectory.isDirectory()) {
            throw new IllegalArgumentException("Bad data file directory: " + dataFileDirectory);
        }
        long start = System.currentTimeMillis();
        KDDCupDataModel model = new KDDCupDataModel(KDDCupDataModel.getTrainingFile(dataFileDirectory));
        Track1Recommender recommender = new Track1Recommender(model);
        long end = System.currentTimeMillis();
        log.info("Loaded model in {}s", (Object)((end - start) / 1000L));
        start = end;
        ArrayList<Track1Callable> callables = Lists.newArrayList();
        for (Pair<PreferenceArray, long[]> tests : new DataFileIterable(KDDCupDataModel.getTestFile(dataFileDirectory))) {
            PreferenceArray userTest = tests.getFirst();
            callables.add(new Track1Callable(recommender, userTest));
        }
        int cores = Runtime.getRuntime().availableProcessors();
        log.info("Running on {} cores", (Object)cores);
        ExecutorService executor = Executors.newFixedThreadPool(cores);
        List results = executor.invokeAll(callables);
        executor.shutdown();
        end = System.currentTimeMillis();
        log.info("Ran recommendations in {}s", (Object)((end - start) / 1000L));
        start = end;
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(args[1])));
        try {
            for (Future result : results) {
                for (byte estimate : (byte[])result.get()) {
                    ((OutputStream)out).write(estimate);
                }
            }
        }
        finally {
            Closeables.close(out, false);
        }
        end = System.currentTimeMillis();
        log.info("Wrote output in {}s", (Object)((end - start) / 1000L));
    }
}

