/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.TextField;
import org.apache.lucene.facet.index.CountingListBuilder;
import org.apache.lucene.facet.index.DrillDownStream;
import org.apache.lucene.facet.params.CategoryListParams;
import org.apache.lucene.facet.params.FacetIndexingParams;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.TaxonomyWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;

public class FacetFields {
    private static final FieldType DRILL_DOWN_TYPE = new FieldType(TextField.TYPE_NOT_STORED);
    protected final TaxonomyWriter taxonomyWriter;
    protected final FacetIndexingParams indexingParams;

    public FacetFields(TaxonomyWriter taxonomyWriter) {
        this(taxonomyWriter, FacetIndexingParams.DEFAULT);
    }

    public FacetFields(TaxonomyWriter taxonomyWriter, FacetIndexingParams params) {
        this.taxonomyWriter = taxonomyWriter;
        this.indexingParams = params;
    }

    protected Map<CategoryListParams, Iterable<CategoryPath>> createCategoryListMapping(Iterable<CategoryPath> categories) {
        if (this.indexingParams.getAllCategoryListParams().size() == 1) {
            return Collections.singletonMap(this.indexingParams.getCategoryListParams(null), categories);
        }
        HashMap<CategoryListParams, Iterable<CategoryPath>> categoryLists = new HashMap<CategoryListParams, Iterable<CategoryPath>>();
        for (CategoryPath cp : categories) {
            CategoryListParams clp = this.indexingParams.getCategoryListParams(cp);
            ArrayList<CategoryPath> list = (ArrayList<CategoryPath>)categoryLists.get(clp);
            if (list == null) {
                list = new ArrayList<CategoryPath>();
                categoryLists.put(clp, list);
            }
            list.add(cp);
        }
        return categoryLists;
    }

    protected Map<String, BytesRef> getCategoryListData(CategoryListParams categoryListParams, IntsRef ordinals, Iterable<CategoryPath> categories) throws IOException {
        return new CountingListBuilder(categoryListParams, this.indexingParams, this.taxonomyWriter).build(ordinals, categories);
    }

    protected DrillDownStream getDrillDownStream(Iterable<CategoryPath> categories) {
        return new DrillDownStream(categories, this.indexingParams);
    }

    protected FieldType drillDownFieldType() {
        return DRILL_DOWN_TYPE;
    }

    protected void addCountingListData(Document doc, Map<String, BytesRef> categoriesData, String field) {
        for (Map.Entry<String, BytesRef> entry : categoriesData.entrySet()) {
            doc.add(new BinaryDocValuesField(field + entry.getKey(), entry.getValue()));
        }
    }

    public void addFields(Document doc, Iterable<CategoryPath> categories) throws IOException {
        if (categories == null) {
            throw new IllegalArgumentException("categories should not be null");
        }
        Map<CategoryListParams, Iterable<CategoryPath>> categoryLists = this.createCategoryListMapping(categories);
        IntsRef ordinals = new IntsRef(32);
        for (Map.Entry<CategoryListParams, Iterable<CategoryPath>> e : categoryLists.entrySet()) {
            CategoryListParams clp = e.getKey();
            String field = clp.field;
            ordinals.length = 0;
            int maxNumOrds = 0;
            for (CategoryPath cp : e.getValue()) {
                int ordinal = this.taxonomyWriter.addCategory(cp);
                if (ordinals.ints.length < (maxNumOrds += cp.length)) {
                    ordinals.grow(maxNumOrds);
                }
                ordinals.ints[ordinals.length++] = ordinal;
            }
            Map<String, BytesRef> categoriesData = this.getCategoryListData(clp, ordinals, e.getValue());
            this.addCountingListData(doc, categoriesData, field);
            DrillDownStream drillDownStream = this.getDrillDownStream(e.getValue());
            Field drillDown = new Field(field, (TokenStream)drillDownStream, this.drillDownFieldType());
            doc.add(drillDown);
        }
    }

    static {
        DRILL_DOWN_TYPE.setIndexOptions(FieldInfo.IndexOptions.DOCS_ONLY);
        DRILL_DOWN_TYPE.setOmitNorms(true);
        DRILL_DOWN_TYPE.freeze();
    }
}

