/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.encoding;

import org.apache.lucene.facet.encoding.ChunksIntEncoder;
import org.apache.lucene.facet.encoding.EightFlagsIntDecoder;
import org.apache.lucene.facet.encoding.IntDecoder;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;

public class EightFlagsIntEncoder
extends ChunksIntEncoder {
    private static final byte[] ENCODE_TABLE = new byte[]{1, 2, 4, 8, 16, 32, 64, -128};

    public EightFlagsIntEncoder() {
        super(8);
    }

    @Override
    public void encode(IntsRef values, BytesRef buf) {
        buf.length = 0;
        buf.offset = 0;
        int upto = values.offset + values.length;
        for (int i = values.offset; i < upto; ++i) {
            int value = values.ints[i];
            if (value == 1) {
                this.indicator |= ENCODE_TABLE[this.ordinal];
            } else {
                this.encodeQueue.ints[this.encodeQueue.length++] = value - 2;
            }
            this.ordinal = (byte)(this.ordinal + 1);
            if (this.ordinal != 8) continue;
            this.encodeChunk(buf);
        }
        if (this.ordinal != 0) {
            this.encodeChunk(buf);
        }
    }

    @Override
    public IntDecoder createMatchingDecoder() {
        return new EightFlagsIntDecoder();
    }

    public String toString() {
        return "EightFlags(VInt)";
    }
}

