/*
 *  globals.h
 *  Eloquent
 *
 *  Created by Manfred Bergmann on 03.06.05.
 *  Copyright 2007 mabe. All rights reserved.
 *
 */

// $Author: $
// $HeadURL: $
// $LastChangedBy: $
// $LastChangedDate: $
// $Rev: $

#import <Cocoa/Cocoa.h>
#import <CoreFoundation/CoreFoundation.h>

#define BUNDLEVERSION			CFBundleGetVersionNumber(CFBundleGetMainBundle())
#define BUNDLEVERSIONSTRING		CFBundleGetValueForInfoDictionaryKey(CFBundleGetMainBundle(), kCFBundleVersionKey)
#define APPNAME					@"MacSword"
#define DEFAULT_APPSUPPORT_PATH	[@"~/Library/Application Support/MacSword" stringByExpandingTildeInPath]
#define DEFAULT_BOOKMARK_PATH   [@"~/Library/Application Support/MacSword/Bookmarks.plist" stringByExpandingTildeInPath]
#define DEFAULT_MODULE_PATH     [@"~/Library/Application Support/Sword" stringByExpandingTildeInPath]
#define SWINSTALLMGR_NAME       @"InstallMgr"
#define LOGFILE					[@"~/Library/Logs/MacSword.log" stringByExpandingTildeInPath]
#define TMPFOLDER				[@"~/Library/Caches/MacSword" stringByExpandingTildeInPath]

// OS version
#define OSVERSION				[[NSDictionary dictionaryWithContentsOfFile:@"/System/Library/CoreServices/SystemVersion.plist"] objectForKey:@"ProductVersion"]

// table and outlineview fonts
#define MBTinyTableViewFont [NSFont fontWithName: @"Lucida Grande" size:9]
#define MBSmallTableViewFont [NSFont fontWithName: @"Lucida Grande" size:10]
#define MBStdTableViewFont [NSFont fontWithName: @"Lucida Grande" size: 11]
#define MBStdBoldTableViewFont [NSFont fontWithName: @"Lucida Grande Bold" size: 11]
#define MBLargeTableViewFont [NSFont fontWithName: @"Lucida Grande" size: 12]
#define MBLargeBoldTableViewFont [NSFont fontWithName: @"Lucida Grande" size: 12]

// define for userdefaults
#define userDefaults [NSUserDefaults standardUserDefaults]

// define some userdefaults keys
#define DEFAULTS_SWMODULE_PATH_KEY      @"SwordModulePath"
#define DEFAULTS_SWINSTALLMGR_PATH_KEY  @"SwordInstallMgrPath"
#define DEFAULTS_BOOKMARK_PATH_KEY      @"SwordBookmarkPath"
#define DEFAULTS_SWINDEX_PATH_KEY       @"SwordIndexPath"

// Notification identifiers

/**
\brief this notification is send when the module list has changed
 */
#define ModuleChangeNotificationName	@"ModuleChangeNotification"
#define SendNotifyModulesChanged(X) [[NSNotificationCenter defaultCenter] postNotificationName:ModuleChangeNotificationName object:X];

