//
//  WebKit_Extensions.m
//  MacSword
//
//  Created by William Thimbleby on Tue Nov 23 2004.
//  Copyright (c) 2004 __MyCompanyName__. All rights reserved.
//

#import "WebKit_Extensions.h"


@implementation WebView (WebKit_Extensions)


- (NSDragOperation)draggingUpdated:(id<NSDraggingInfo>)info
{
    NSPasteboard *pboard = [info draggingPasteboard];
    NSArray *types = [pboard types];
	
	if([types containsObject:@"relative url"]) {
		return 3;
	}
	
	return 0;
}

- (BOOL)performDragOperation:(id <NSDraggingInfo>)info
{
    NSPasteboard *pboard = [info draggingPasteboard];
	NSString *urlString = [pboard stringForType:@"relative url"];
	
	[[self UIDelegate] openURLString:urlString];

	return YES;
}

@end