/*	ToolbarDelegateCategory.m - Handles the toolbar for the document windows

	$Id: ToolbarDelegateCategory.m,v 1.3 2006/02/02 00:18:23 willthimbleby Exp $
	
	Copyright 2003 Will Thimbleby (will@thimbleby.net)
	
	This program is free software; you can redistribute it and/or modify it under the terms of the
	GNU General Public License as published by the Free Software Foundation version 2.
	
	This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
	even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
	General Public License for more details. (http://www.gnu.org/licenses/gpl.html)
*/

#import "ToolbarDelegateCategory.h"
#import "ModuleToolbarView.h"

static NSString*	ForwardToolbarItemIdentifier 		= @"Forward Item Identifier";
static NSString*	BackToolbarItemIdentifier 			= @"Back Item Identifier";
static NSString*	BookmarkToolbarItemIdentifier 		= @"Bookmark Item Identifier";
static NSString*	ContentsToolbarItemIdentifier 		= @"Contents Item Identifier";

static NSString*	BiggerToolbarItemIdentifier			= @"Bigger Item Identifier";
static NSString*	SmallerToolbarItemIdentifier 		= @"Smaller Item Identifier";
static NSString*	NextChapterToolbarItemIdentifier	= @"Next Chapter Item Identifier";
static NSString*	PreviousChapterToolbarItemIdentifier= @"Previous Chapter Identifier";
static NSString*	NextBookToolbarItemIdentifier		= @"Next Book Item Identifier";
static NSString*	PreviousBookToolbarItemIdentifier   = @"Previous Book Identifier";

/*
static NSString*	NextMonthToolbarItemIdentifier		= @"Next Month Item Identifier";
static NSString*	PreviousMonthToolbarItemIdentifier	= @"Previous Month Identifier";
static NSString*	NextDayToolbarItemIdentifier		= @"Next Day Item Identifier";
static NSString*	PreviousDayToolbarItemIdentifier	= @"Previous Day Identifier";
*/

static NSString*	URLBarToolbarItemIdentifier 		= @"URL Item Identifier";
static NSString*	ModuleToolbarItemIdentifier 		= @"Module Item Identifier";
static NSString*	SimpleBibleToolbarItemIdentifier 	= @"Simple Bible Item Identifier";

static NSString*	DevotionalToolbarItemIdentifier 	= @"Devotional Item Identifier";
static NSString*	DictionaryToolbarItemIdentifier 	= @"Dictionary Item Identifier";

static NSString*	BibleToolbarIdentifier 				= @"bible toolbar";
static NSString*	DictionaryToolbarIdentifier 		= @"dictionary toolbar";
static NSString*	DevotionalToolbarIdentifier 		= @"devotional toolbar";
static NSString*	BookToolbarIdentifier				= @"book toolbar";

@implementation MyDocument (ToolbarDelegateCategory)

- (void) setupToolbar
{
    // Create a new toolbar instance, and attach it to our document window 
	switch(type)
	{
		case bible:
		case commentary:
			toolbar = [[[NSToolbar alloc] initWithIdentifier: BibleToolbarIdentifier] autorelease];
			[toolbar setAllowsUserCustomization: YES];
			
			//create module popup
	
			//[self addArray:[[SwordManager defaultManager] swordModulesForFeature:@"HebrewDef"] toMenu:[strongsHebrewPopup menu]];
			
			break;
		case dictionary:
			toolbar = [[[NSToolbar alloc] initWithIdentifier: DictionaryToolbarIdentifier] autorelease];
			[toolbar setAllowsUserCustomization: YES];
			break;
		case devotional:
			toolbar = [[[NSToolbar alloc] initWithIdentifier: DevotionalToolbarIdentifier] autorelease];
			[toolbar setAllowsUserCustomization: YES];
			break;
		case book:
			toolbar = [[[NSToolbar alloc] initWithIdentifier: BookToolbarIdentifier] autorelease];
			[toolbar setAllowsUserCustomization: YES];
			break;
		default:
			toolbar = [[[NSToolbar alloc] initWithIdentifier: BibleToolbarIdentifier] autorelease];
			[toolbar setAllowsUserCustomization: YES];
			break;
	}
	
    // Set up toolbar properties: Give a default display mode, and remember state in user defaults 
    [toolbar setAutosavesConfiguration: YES];
    [toolbar setDisplayMode: NSToolbarDisplayModeIconOnly];
    
    // We are the delegate
    [toolbar setDelegate: self];
    
    // Attach the toolbar to the document window 
    [myWindow setToolbar: toolbar];
}

-(void)addModule:(id)sender
{
	NSArray *a = [[[self window] toolbar] items];
	
	int i;
	for(i=0;i<[a count];i++)
	{
		if([[[a objectAtIndex:i] itemIdentifier] isEqualToString:ModuleToolbarItemIdentifier])
		{
			[[a objectAtIndex:i] setMinSize:NSMakeSize(187, 22)];
			[[a objectAtIndex:i] setMaxSize:NSMakeSize(187, 22)]; 
		}
	}
}

- (NSToolbarItem *) toolbar: (NSToolbar *)toolbar itemForItemIdentifier: (NSString *) itemIdent willBeInsertedIntoToolbar:(BOOL) willBeInserted
{
    // Required delegate method   Given an item identifier, self method returns an item 
    // The toolbar will use self method to obtain toolbar items that can be displayed in the customization sheet, or in the toolbar itself 
    NSToolbarItem *toolbarItem = [[[NSToolbarItem alloc] initWithItemIdentifier: itemIdent] autorelease];
    
    if ([itemIdent isEqual: ForwardToolbarItemIdentifier])
	{
		[toolbarItem setLabel: NSLocalizedString(@"Forward", @"Forward toolbar label")];
		[toolbarItem setPaletteLabel: NSLocalizedString(@"Forward", @"Forward toolbar label")];
		
		[toolbarItem setToolTip: NSLocalizedString(@"Show next reference", @"Forward toolbar tool-tip")];
		[toolbarItem setImage: [NSImage imageNamed: @"forward"]];
		
		[toolbarItem setTarget: [self webView]];
		[toolbarItem setAction: @selector(goForward:)];
    }
	else if ([itemIdent isEqual: BackToolbarItemIdentifier])
	{
		[toolbarItem setLabel: NSLocalizedString(@"Back", @"Back toolbar label")];
		[toolbarItem setPaletteLabel: NSLocalizedString(@"Back", @"Back toolbar label")];
		
		[toolbarItem setToolTip: NSLocalizedString(@"Show previous reference", @"Back toolbar tool-tip")];
		[toolbarItem setImage: [NSImage imageNamed: @"back"]];
		
		[toolbarItem setTarget: [self webView]];
		[toolbarItem setAction: @selector(goBack:)];
    }
	else if ([itemIdent isEqual: BookmarkToolbarItemIdentifier])
	{
		[toolbarItem setLabel: NSLocalizedString(@"Bookmarks", @"Bookmarks toolbar label")];
		[toolbarItem setPaletteLabel: NSLocalizedString(@"Bookmarks", @"Bookmarks toolbar label")];
		
		[toolbarItem setToolTip: NSLocalizedString(@"Show bookmarks drawer", @"Bookmarks toolbar tool-tip (Show bookmarks drawer)")];
		[toolbarItem setImage: [NSImage imageNamed: @"Bookmark"]];
		
		[toolbarItem setTarget: self];
		[toolbarItem setAction: @selector(toggleBookmarks:)];
    }
	else if ([itemIdent isEqual: URLBarToolbarItemIdentifier])
	{		
		[toolbarItem setLabel: NSLocalizedString(@"Reference", @"Reference bar (advanced) label")];
		[toolbarItem setPaletteLabel: NSLocalizedString(@"Reference", @"Reference bar (advanced) label")];
		
		[toolbarItem setToolTip: NSLocalizedString(@"Type a reference to open then press return", @"Reference bar (advanced) tool-tip")];
		[toolbarItem setView: referenceView];
		
		[toolbarItem setMinSize:NSMakeSize(100, 22)];
		[toolbarItem setMaxSize:NSMakeSize(10000, 22)];
    }
	else if ([itemIdent isEqual: SimpleBibleToolbarItemIdentifier])
	{		
		[toolbarItem setLabel: NSLocalizedString(@"Navigation", @"Navigation (simple) label")];
		[toolbarItem setPaletteLabel: NSLocalizedString(@"Simple Navigation", @"Navigation (simple) palette label")];
		
		[toolbarItem setToolTip: NSLocalizedString(@"Select book and a chapter to view", @"Navigation tool-tip (Select book and a chapter to view)")];
		[toolbarItem setView: simpleBibleView];
		
		[toolbarItem setMinSize:NSMakeSize(187, 22)];
		[toolbarItem setMaxSize:NSMakeSize(187, 22)];
    }
	else if ([itemIdent isEqual: ModuleToolbarItemIdentifier])
	{		
		[toolbarItem setLabel: NSLocalizedString(@"Module", @"Module label")];
		[toolbarItem setPaletteLabel: NSLocalizedString(@"Module", @"Module label")];
		
		[toolbarItem setToolTip: NSLocalizedString(@"Select a module to view", @"Module tool-tip")];
		
		moduleView = [[ModuleToolbarView alloc] initWithDocument:self andToolbarItem:toolbarItem];
		[toolbarItem setView: moduleView];
		
    }
	else if ([itemIdent isEqual: DevotionalToolbarItemIdentifier])
	{		
		[toolbarItem setLabel: NSLocalizedString(@"Date", @"Date label")];
		[toolbarItem setPaletteLabel: NSLocalizedString(@"Date selector", @"Date palette label")];
		
		[toolbarItem setToolTip: NSLocalizedString(@"Select a date for a devotional", @"Date tool-tip")];
		[toolbarItem setView: devotionalView];
		
		[toolbarItem setMinSize:NSMakeSize(220, 22)];
		[toolbarItem setMaxSize:NSMakeSize(220, 22)];
    }
	else if ([itemIdent isEqual: DictionaryToolbarItemIdentifier])
	{		
		[toolbarItem setLabel: NSLocalizedString(@"Entry", @"Entry label")];
		[toolbarItem setPaletteLabel: NSLocalizedString(@"Entry selector", @"Entry palette label")];
		
		[toolbarItem setToolTip: NSLocalizedString(@"Select entry", @"Entry tool-tip")];
		[toolbarItem setView: dictView];
		
		[toolbarItem setMinSize:NSMakeSize(125, 22)];
		[toolbarItem setMaxSize:NSMakeSize(125, 22)];
    }
	else if ([itemIdent isEqual: BiggerToolbarItemIdentifier])
	{
		[toolbarItem setLabel: NSLocalizedString(@"Make Text Bigger", @"Larger toolbar label")];
		[toolbarItem setPaletteLabel: NSLocalizedString(@"Make Text Bigger", @"Larger toolbar label")];
		
		[toolbarItem setToolTip: NSLocalizedString(@"Make Text Bigger", @"Larger toolbar tool-tip")];
		[toolbarItem setImage: [NSImage imageNamed: @"bigger"]];
		
		[toolbarItem setTarget: self];
		[toolbarItem setAction: @selector(makeTextLarger:)];
    }
	else if ([itemIdent isEqual: SmallerToolbarItemIdentifier])
	{
		[toolbarItem setLabel: NSLocalizedString(@"Make Text Smaller", @"Smaller toolbar label")];
		[toolbarItem setPaletteLabel: NSLocalizedString(@"Make Text Smaller", @"Smaller toolbar label")];
		
		[toolbarItem setToolTip: NSLocalizedString(@"Make Text Smaller", @"Smaller toolbar tool-tip")];
		[toolbarItem setImage: [NSImage imageNamed: @"smaller"]];
		
		[toolbarItem setTarget: self];
		[toolbarItem setAction: @selector(makeTextSmaller:)];
    }
	else if ([itemIdent isEqual: NextBookToolbarItemIdentifier])
	{
		[toolbarItem setLabel: NSLocalizedString(@"Next Book/Entry", @"Next Book/Entry toolbar label")];
		[toolbarItem setPaletteLabel: NSLocalizedString(@"Next Book/Entry", @"Next Book/Entry toolbar label")];
		
		[toolbarItem setToolTip: NSLocalizedString(@"Next Book/Entry", @"Next Book/Entry toolbar tool-tip")];
		[toolbarItem setImage: [NSImage imageNamed: @"nextBook"]];
		
		[toolbarItem setTarget: self];
		[toolbarItem setAction: @selector(nextBook:)];
    }
	else if ([itemIdent isEqual: PreviousBookToolbarItemIdentifier])
	{
		[toolbarItem setLabel: NSLocalizedString(@"Previous Book/Entry", @"Previous Book/Entry toolbar label")];
		[toolbarItem setPaletteLabel: NSLocalizedString(@"Previous Book/Entry", @"Previous Book/Entry toolbar label")];
		
		[toolbarItem setToolTip: NSLocalizedString(@"Previous Book/Entry", @"Previous Book/Entry toolbar tool-tip")];
		[toolbarItem setImage: [NSImage imageNamed: @"previousBook"]];
		
		[toolbarItem setTarget: self];
		[toolbarItem setAction: @selector(previousBook:)];
    }
	else if ([itemIdent isEqual: NextChapterToolbarItemIdentifier])
	{
		[toolbarItem setLabel: NSLocalizedString(@"Next Chapter", @"Next Chapter toolbar label")];
		[toolbarItem setPaletteLabel: NSLocalizedString(@"Next Chapter", @"Next Chapter toolbar label")];
		
		[toolbarItem setToolTip: NSLocalizedString(@"Next Chapter", @"Next Chapter toolbar tool-tip")];
		[toolbarItem setImage: [NSImage imageNamed: @"nextChapter"]];
		
		[toolbarItem setTarget: self];
		[toolbarItem setAction: @selector(nextChapter:)];
    }
	else if ([itemIdent isEqual: PreviousChapterToolbarItemIdentifier])
	{
		[toolbarItem setLabel: NSLocalizedString(@"Previous Chapter", @"Previous Chapter toolbar label")];
		[toolbarItem setPaletteLabel: NSLocalizedString(@"Previous Chapter", @"Previous Chapter toolbar label")];
		
		[toolbarItem setToolTip: NSLocalizedString(@"Previous Chapter", @"Previous Chapter toolbar tool-tip")];
		[toolbarItem setImage: [NSImage imageNamed: @"previousChapter"]];
		
		[toolbarItem setTarget: self];
		[toolbarItem setAction: @selector(previousChapter:)];
    }
	else if ([itemIdent isEqual: ContentsToolbarItemIdentifier])
	{
		[toolbarItem setLabel: NSLocalizedString(@"Contents", @"Show Contents toolbar label")];
		[toolbarItem setPaletteLabel: NSLocalizedString(@"Contents", @"Show Contents toolbar label")];
		
		[toolbarItem setToolTip: NSLocalizedString(@"Show Contents", @"Show Contents toolbar tool-tip")];
		[toolbarItem setImage: [NSImage imageNamed: @"contents"]];
		
		[toolbarItem setTarget: self];
		[toolbarItem setAction: @selector(toggleContents:)];
    }
	
    return toolbarItem;
}

- (NSArray *) toolbarDefaultItemIdentifiers: (NSToolbar *) theToolbar
{
    // Required delegate method   Returns the ordered list of items to be shown in the toolbar by default    
    // If during the toolbar's initialization, no overriding values are found in the user defaults, or if the
    // user chooses to revert to the default items self set will be used
	
	if([[theToolbar identifier] isEqual:DevotionalToolbarIdentifier])
	{
		return [NSArray arrayWithObjects: DevotionalToolbarItemIdentifier, nil];
	}
	else if([[theToolbar identifier] isEqual:DictionaryToolbarIdentifier])
	{
		return [NSArray arrayWithObjects: BackToolbarItemIdentifier, ForwardToolbarItemIdentifier, NSToolbarSeparatorItemIdentifier, DictionaryToolbarItemIdentifier, nil];
	}
	else if([[theToolbar identifier] isEqual:BookToolbarIdentifier])
	{
		return [NSArray arrayWithObjects: BackToolbarItemIdentifier, ForwardToolbarItemIdentifier, NSToolbarSeparatorItemIdentifier, NextBookToolbarItemIdentifier, PreviousBookToolbarItemIdentifier, NSToolbarFlexibleSpaceItemIdentifier, ContentsToolbarItemIdentifier, nil];
	}
	else
	{
		return [NSArray arrayWithObjects: BackToolbarItemIdentifier, ForwardToolbarItemIdentifier, NSToolbarSeparatorItemIdentifier, 
					ModuleToolbarItemIdentifier, SimpleBibleToolbarItemIdentifier, NSToolbarFlexibleSpaceItemIdentifier,
					BookmarkToolbarItemIdentifier, nil];
	}
}

- (NSArray *) toolbarAllowedItemIdentifiers: (NSToolbar *) theToolbar
{
    // Required delegate method   Returns the list of all allowed items by identifier   By default, the toolbar 
    // does not assume any items are allowed, even the separator   So, every allowed item must be explicitly listed   
    // The set of allowed items is used to construct the customization palette
	
    if([[theToolbar identifier] isEqual:DevotionalToolbarIdentifier])
	{
		return [NSArray arrayWithObjects:	DevotionalToolbarItemIdentifier,        
					NSToolbarCustomizeToolbarItemIdentifier,  NSToolbarPrintItemIdentifier,
					NSToolbarSeparatorItemIdentifier,
					NSToolbarFlexibleSpaceItemIdentifier, NSToolbarSpaceItemIdentifier,
					BiggerToolbarItemIdentifier, SmallerToolbarItemIdentifier,
					NextBookToolbarItemIdentifier, PreviousBookToolbarItemIdentifier, nil];
		/*			
		NextMonthToolbarItemIdentifier, PreviousMonthToolbarItemIdentifier,
					NextDayToolbarItemIdentifier, PreviousDayToolbarItemIdentifier, nil];
		*/
	}
	else if([[theToolbar identifier] isEqual:DictionaryToolbarIdentifier])
	{
		return [NSArray arrayWithObjects:	BackToolbarItemIdentifier, ForwardToolbarItemIdentifier, 
					DictionaryToolbarItemIdentifier,        
					NSToolbarCustomizeToolbarItemIdentifier,  NSToolbarPrintItemIdentifier,
					NSToolbarSeparatorItemIdentifier,
					NSToolbarFlexibleSpaceItemIdentifier, NSToolbarSpaceItemIdentifier,
					BiggerToolbarItemIdentifier, SmallerToolbarItemIdentifier,
					NextBookToolbarItemIdentifier, PreviousBookToolbarItemIdentifier, nil];
	}
	else if([[theToolbar identifier] isEqual:BookToolbarIdentifier])
	{
		return [NSArray arrayWithObjects:	BackToolbarItemIdentifier, ForwardToolbarItemIdentifier, 
					ContentsToolbarItemIdentifier,        
					NSToolbarCustomizeToolbarItemIdentifier,  NSToolbarPrintItemIdentifier,
					NSToolbarSeparatorItemIdentifier,
					NSToolbarFlexibleSpaceItemIdentifier, NSToolbarSpaceItemIdentifier,
					BiggerToolbarItemIdentifier, SmallerToolbarItemIdentifier,
					NextBookToolbarItemIdentifier, PreviousBookToolbarItemIdentifier, nil];
	}
	else
	{
		return [NSArray arrayWithObjects:	BackToolbarItemIdentifier, 
					ForwardToolbarItemIdentifier, BookmarkToolbarItemIdentifier,
					ModuleToolbarItemIdentifier, URLBarToolbarItemIdentifier, SimpleBibleToolbarItemIdentifier,
					NSToolbarCustomizeToolbarItemIdentifier,  NSToolbarPrintItemIdentifier,
					NSToolbarSeparatorItemIdentifier,
					NSToolbarFlexibleSpaceItemIdentifier, NSToolbarSpaceItemIdentifier,
					BiggerToolbarItemIdentifier, SmallerToolbarItemIdentifier,
					NextBookToolbarItemIdentifier, PreviousBookToolbarItemIdentifier,
					NextChapterToolbarItemIdentifier, PreviousChapterToolbarItemIdentifier, nil];
	}
}

- (BOOL) validateToolbarItem: (NSToolbarItem *) toolbarItem
{
    // Optional method   self message is sent to us since we are the target of some toolbar item actions 
    // (for example:  of the save items action) 
/*	
    if ([[toolbarItem itemIdentifier] isEqual: BackToolbarItemIdentifier])
	{
		return [[self webView] canGoBack];
    }
	else if ([[toolbarItem itemIdentifier] isEqual: ForwardToolbarItemIdentifier])
	{
		return [[self webView] canGoForward];
    }
*/	
    return YES;
}

@end
