/*	PrefHandler.h - Handles all preferences

	$Id: PrefHandler.h,v 1.8 2006/02/02 00:34:19 willthimbleby Exp $
	
	Copyright 2002 Will Thimbleby (wjt100@york.ac.uk)
	
	This program is free software; you can redistribute it and/or modify it under the terms of the
	GNU General Public License as published by the Free Software Foundation version 2.
	
	This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
	even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
	General Public License for more details. (http://www.gnu.org/licenses/gpl.html)
*/

/*
 changes by Manfred Bergmann
 */

#import <Cocoa/Cocoa.h>

@interface PrefHandler : NSObject
{
    NSUserDefaults	*defaults;
	
	IBOutlet id descriptionSwitch;
    IBOutlet id	autoDevoteSwitch;
    IBOutlet id	hiliteSwitch;
    IBOutlet id	toolTipSwitch;
    IBOutlet id	insetTextSwitch;
    IBOutlet id	rememberWindowsSwitch;
    IBOutlet id	defaultOneLineSwitch;
    IBOutlet id	defaultZoomPopup;
	
    IBOutlet id findWindow;
    IBOutlet id biblePanel;
    IBOutlet id prefPanel;
	
    IBOutlet id serviceBiblePopup;
    IBOutlet id devotionalPopup;
    IBOutlet id strongsGreekPopup;
    IBOutlet id strongsHebrewPopup;
    IBOutlet id morphGreekPopup;
    IBOutlet id morphHebrewPopup;
	
    IBOutlet id	cacheLexiconSwitch;
	
	//style preferences
    IBOutlet NSColorWell *styleTextColorWell;
    IBOutlet NSColorWell *styleBackgroundColorWell;
    IBOutlet NSColorWell *styleXRefColorWell;
    IBOutlet NSColorWell *styleFootnoteColorWell;
    IBOutlet NSColorWell *styleMorphColorWell;
    IBOutlet NSColorWell *styleStrongsColorWell;
    IBOutlet NSColorWell *styleJesusColorWell;
    IBOutlet NSColorWell *styleTitleColorWell;
	
    IBOutlet id	fontTextBox;
    IBOutlet id	styleSheetPopup;
	
    IBOutlet id	locationTextBox;
}
- (id)init;
- (void)start:(id)info;

- (IBAction)updatePreferences:(id)sender;

- (void)selectPopup:(NSPopUpButton*)menu withKey:(NSString*)key;

- (IBAction)selectFont:(id)sender;
- (void)setFont:(NSFont*)newFont;
- (void)changeFont:(id)fontManager;

- (IBAction)chooseLocation:(id)sender;
- (void)openPanelDidEnd:(NSOpenPanel *)sheet returnCode:(int)returnCode contextInfo:(void  *)contextInfo;

- (void)setupMenus;
- (void)setupPopUpButton:(NSPopUpButton*)button;
- (NSMenuItem*)copyMenuItem:(NSMenuItem*)menuItem;
- (IBAction)updatePreferences:(id)sender;

- (void)updateMenuItemsTitle:(NSArray*)menuItemArray;
- (void)updateMenuTitles:(id)sender;

- (void)chooseStyleSheet:(id)sender;
- (void)createStyleSheetPopup;

- (void)openWindows;
- (void)saveWindows;
@end

@interface NSMenu (MenuAdditions)

- (void)addArray:(NSArray*)names;

@end

