//
//  ModuleToolbarView.m
//  MacSword
//
//  Created by William Thimbleby on Mon Mar 14 2005.
//  Copyright (c) 2005 __MyCompanyName__. All rights reserved.
//

/*
 changes by Manfred Bergmann
 */

#import "ModuleToolbarView.h"
#import "SwordManager.h"


@implementation ModuleToolbarView

- (id)initWithDocument:(MyDocument*)doc andToolbarItem:(NSToolbarItem*)ti
{
	NSRect frame = NSMakeRect(0,0, 12, 24);
    self = [super initWithFrame:frame];
    if (self)
	{
		document = doc;
		toolbarItem = ti;
		
		modulePopUpButtons = [[NSMutableArray alloc] init];
		
		[toolbarItem setMinSize:NSMakeSize(12, 22)];
		[toolbarItem setMaxSize:NSMakeSize(12, 22)];
		
		NSButton *addButton = [[NSButton alloc] initWithFrame:NSMakeRect(frame.size.width-11, 5, 11, 11)];
		[addButton setButtonType:NSMomentaryPushInButton];
		[addButton setBordered:NO];
		[addButton setImage:[NSImage imageNamed:@"Add_Module"]];
		[addButton setImagePosition:NSImageOnly];
		[addButton setAutoresizingMask:NSViewMinXMargin];
		[addButton setTarget:self];
		[addButton setAction:@selector(addModule:)];
		
		[self addSubview:addButton];
		[addButton autorelease];
			
		[self addModule];
		//[self addModule];
    }
    return self;
}

- (void)dealloc
{
	[modulePopUpButtons release];
    [super dealloc];
}

- (void)addModule:(id)sender
{
	[self addModule];
}

- (void)addModule
{
	NSRect frame = [self frame];
	
	frame.size.width += 60;
	[self setFrame:frame];
	
	[toolbarItem setMinSize:NSMakeSize(frame.size.width, 22)];
	[toolbarItem setMaxSize:NSMakeSize(frame.size.width, 22)];

	NSPopUpButton *modulePopup = [[NSPopUpButton alloc] initWithFrame:NSMakeRect(frame.size.width-70, 1, 60, 20) pullsDown:NO];
		
	//small
	[[modulePopup cell] setControlSize:NSSmallControlSize];
	[[modulePopup cell] setFont:[NSFont controlContentFontOfSize:10]];
	//[modulePopup setBordered:NO];
	//[[modulePopup cell] setImage:[NSImage imageNamed:@"Book"]];
	//[modulePopup setImage:[NSImage imageNamed:@"Book"]];
	//[[modulePopup cell] setImagePosition:NSImageOnly];
	//[[modulePopup cell] setArrowPosition:NSPopUpNoArrow];
	
	//fix for tiger wrapping popups differently
	if([NSCell instancesRespondToSelector:@selector(setLineBreakMode:)])
		[[modulePopup cell] setLineBreakMode:NSLineBreakByClipping];
	
	[modulePopup setImagePosition:NSNoImage];
	
	//fill popup
	NSArray		*bibles, *commentaries;
	
	bibles = [[SwordManager defaultManager] swordModulesForType:@"Biblical Texts"];
	commentaries = [[SwordManager defaultManager] swordModulesForType:@"Commentaries"];

	[modulePopup removeAllItems];
	[[modulePopup menu] addArray:bibles];
	if([bibles count] > 0) [[modulePopup menu] addItem:[NSMenuItem separatorItem]];
	[[modulePopup menu] addArray:commentaries];
	
	[[modulePopup menu] addItem:[NSMenuItem separatorItem]];
	
	NSMenuItem *removeItem = [[NSMenuItem alloc] initWithTitle:NSLocalizedString(@"Remove", @"Remove a module -- from the popupmenu to select modules") action:@selector(remove:) keyEquivalent:@""];
	[[modulePopup menu] addItem:removeItem];
	[removeItem setRepresentedObject:modulePopup];
	[removeItem setTag:-1];
	[removeItem setTarget:self];
	[removeItem release];
	
	//[[[modulePopup menu] itemArray] makeObjectsPerformSelector:@selector(setImage:) withObject:[NSImage imageNamed:@"Book"]];
	
	//connect action
	[modulePopup setTarget:self];
	[modulePopup setAction:@selector(changeModule:)];
	
	
	[self addSubview:modulePopup];
	[modulePopUpButtons addObject:modulePopup];
	[modulePopup autorelease];
}

- (BOOL)validateMenuItem:(NSMenuItem*)anItem {
    if ([anItem tag] == -1 && [modulePopUpButtons count] <= 1) {
        return NO;
    }

    return YES;
}

- (void)remove:(id)sender {
	NSRect frame = [self frame];
	
	frame.size.width -= 60;
	[self setFrame:frame];
	
	[toolbarItem setMinSize:NSMakeSize(frame.size.width, 22)];
	[toolbarItem setMaxSize:NSMakeSize(frame.size.width, 22)];
	
	
	//remove
	[[sender representedObject] removeFromSuperview];
	int index = [modulePopUpButtons indexOfObject:[sender representedObject]];
	[modulePopUpButtons removeObject:[sender representedObject]];
	
	while(index < [modulePopUpButtons count])
	{
		NSRect f = [[modulePopUpButtons objectAtIndex:index] frame];
		
		f.origin.x -= 60;
		[[modulePopUpButtons objectAtIndex:index] setFrame:f];
		
		index++;
	}
	
	[self setNeedsDisplay:YES];
	[self changeModule:self];
}

- (void)removeModule
{
	NSRect frame = [self frame];
	
	frame.size.width -= 60;
	[self setFrame:frame];
	
	[toolbarItem setMinSize:NSMakeSize(frame.size.width, 22)];
	[toolbarItem setMaxSize:NSMakeSize(frame.size.width, 22)];
	
	//remove
	[[modulePopUpButtons lastObject] removeFromSuperview];
	[modulePopUpButtons removeLastObject];
}

- (void)changeModule:(id)sender
{
	[document changeModuleTo:[self hostURL]];
}

- (void)setModules:(NSURL*)aUrl
{
	NSArray *modules = [[aUrl host] componentsSeparatedByString:@"."];
	int i;
	
	if([modules count] > [modulePopUpButtons count])
	{
		for(i=[modulePopUpButtons count];i<[modules count];i++)
			[self addModule];
	}
	else if([modules count] < [modulePopUpButtons count])
	{
		for(i=[modulePopUpButtons count];i>[modules count];i--)
			[self removeModule];
	}
	
	for(i=0;i<[modulePopUpButtons count];i++)
	{
		SwordModule *module = [[SwordManager defaultManager] moduleForURL:[NSURL URLWithString:[NSString stringWithFormat:@"//%@",[modules objectAtIndex:i]]]];
		NSString *title = [module moduleName];
		NSLog(@"%@=>%@",[modules objectAtIndex:i],title);
		[[modulePopUpButtons objectAtIndex:i] selectItemWithTitle:title];
	}
}

- (NSString*)modulesTitle
{
	NSString *title = @"", *modName;
	int i;
	for(i=0;i<[modulePopUpButtons count];i++)
	{
		NSPopUpButton *modulePopup = [modulePopUpButtons objectAtIndex:i];
		id item = [modulePopup selectedItem];
		if(item)
			modName = [item representedObject];
		else
			modName = @"";
		
		SwordModule *module = [[SwordManager defaultManager] moduleForURL:[NSURL URLWithString:[NSString stringWithFormat:@"//%@",modName]]];
		title = [title stringByAppendingString:[module moduleName]];
		if(i+1 < [modulePopUpButtons count])
			title = [title stringByAppendingString:@" | "];
	}
	return title;
}

- (NSString*)hostURL
{
	NSMutableString *host = [NSMutableString stringWithCapacity:10];
	
	NSPopUpButton *modulePopup;
	int i;
	for(i=0;i<[modulePopUpButtons count];i++)
	{
		modulePopup = [modulePopUpButtons objectAtIndex:i];
		[host appendString: [[modulePopup selectedItem] representedObject] ];
		if(i<[modulePopUpButtons count]-1)
			[host appendString: @"." ];
	}
	
	return host;
}

- (BOOL)modulesHaveFeature:(NSString*)feature
{
	int i;
	for(i=0;i<[modulePopUpButtons count];i++)
	{
		NSPopUpButton *modulePopup = [modulePopUpButtons objectAtIndex:i];
		SwordModule *module = [[SwordManager defaultManager] moduleWithName:[[modulePopup selectedItem] representedObject] ];
		
		if([module hasFeature:feature])
			return YES;
	}
	return NO;
}

@end
