/* ModuleManager */
/*
 created by Manfred Bergmann in 2007
 */

#import <Cocoa/Cocoa.h>
#import <CocoLogger/CocoLogger.h>
#import <Module.h>
#import <Category.h>

@interface ModuleManageHelper : NSWindowController
{
    IBOutlet NSButton *closeButton;
    IBOutlet NSOutlineView *installOutlineView;
    IBOutlet NSButton *processButton;
    IBOutlet NSProgressIndicator *progressBar;
    IBOutlet NSTabView *tabView;

	NSMutableArray *categoryList;
	NSMutableArray *installedModuleList;
	NSMutableArray *remoteModuleList;
}

+ (ModuleManageHelper *)sharedManager;

// init
- (id)init;

// data
- (NSArray *)installedModules;
- (NSArray *)availableCategories;

// rescanning of any module changes
- (void)rescanInstalledModules;

// actions
- (IBAction)closeButton:(id)sender;
- (IBAction)processButton:(id)sender;

@end
