//
//  Module.m
//  MacSword
//
//  Created by Manfred Bergmann on 13.01.07.
//  Copyright 2007 __MyCompanyName__. All rights reserved.
//

#import "Module.h"


@implementation Module

// convenience allocators
+ (Module *)moduleForName:(NSString *)aName andDescription:(NSString *)aDescription
{
	return [[[Module alloc] initWithName:aName andDescription:aDescription] autorelease];
}

- (id)init
{
	return [self initWithName:nil andDescription:nil];
}

/**
\brief init new Module with name and description
 */
- (id)initWithName:(NSString *)aName andDescription:(NSString *)aDescription
{
	self = [super init];
	if(self != nil)
	{
		[self setName:aName];
		[self setDescr:aDescription];
	}
	
	return self;
}

- (void)dealloc
{
	[self setName:nil];
	[self setDescr:nil];
	
	[super dealloc];
}

// ------------------------------------
// getter/setter
// ------------------------------------
- (NSString *)name
{
    return [[name retain] autorelease];
}

- (void)setName:(NSString *)value
{
    if(name != value)
	{
        [name release];
        name = [value copy];
    }
}

- (NSString *)descr 
{
    return [[descr retain] autorelease];
}

- (void)setDescr:(NSString *)value 
{
    if(descr != value) 
	{
        [descr release];
        descr = [value copy];
    }
}

@end
