//
//  Category.m
//  MacSword
//
//  Created by Manfred Bergmann on 13.01.07.
//  Copyright 2007 __MyCompanyName__. All rights reserved.
//

#import "Category.h"


@implementation Category

+ (Category *)categoryForName:(NSString *)aName
{
	return [[[Category alloc] initWithName:aName] autorelease];
}

- (id)init
{
	return [self initWithName:nil];
}

/**
\brief init new Category with name
 */
- (id)initWithName:(NSString *)aName
{
	self = [super init];
	if(self != nil)
	{
		[self setName:aName];
		[self setContent:[NSMutableArray array]];
	}
	
	return self;
}

- (void)dealloc
{
	[self setName:nil];
	[self setContent:nil];
	
	[super dealloc];
}

/**
\brief add a module to the content of this category
 */
- (void)addModule:(Module *)aModule
{
	if(aModule != nil)
	{
		[content addObject:aModule];
	}
}

// ------------------------------------
// getter/setter
// ------------------------------------
- (NSString *)name
{
    return [[name retain] autorelease];
}

- (void)setName:(NSString *)value
{
    if (name != value)
	{
        [name release];
        name = [value copy];
    }
}

- (NSArray *)content
{
    return [[content retain] autorelease];
}

- (void)setContent:(NSArray *)value
{
    if (content != value)
	{
        [content release];
        content = [value mutableCopy];
    }
}

@end
