//
//  Category.h
//  MacSword
//
//  Created by Manfred Bergmann on 13.01.07.
//  Copyright 2007 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <Module.h>

// moduletype definitions
#define ModuleTypeBiblicalText		@"Biblical Texts"
#define ModuleTypeCommentary		@"Commentaries"
#define ModuleTypeDictionary		@"Lexicons / Dictionaries"
#define ModuleTypeGenBook			@"Generic Books"
#define ModuleTypeUnorthodox		@"Unorthodox"
#define ModuleTypeDailyDevotion		@"DailyDevotion"

@interface Category : NSObject
{
	NSString *name;
	NSMutableArray *content;
}

// convenience allocators
+ (Category *)categoryForName:(NSString *)aName;

// init
- (id)init;
- (id)initWithName:(NSString *)aName;

// getters / setters
- (NSString *)name;
- (void)setName:(NSString *)value;

- (NSArray *)content;
- (void)setContent:(NSArray *)value;

- (void)addModule:(Module *)aModule;

@end
