/*	ModuleList.m - Handles the listing of the indivdual modules in a outline view

	$Id: ContentsHandler.m,v 1.1 2006/02/02 00:19:25 willthimbleby Exp $
	
	Copyright 2003 Will Thimbleby (will@thimbleby.net)
	
	This program is free software; you can redistribute it and/or modify it under the terms of the
	GNU General Public License as published by the Free Software Foundation version 2.
	
	This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
	even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
	General Public License for more details. (http://www.gnu.org/licenses/gpl.html)
*/

/*
 changes by Manfred Bergmann
 */

#import "ContentsHandler.h"
#import "SwordBook.h"

@interface ContentsHandler (PrivateAPI)

- (void)setContents:(NSArray *)value;

@end

@implementation ContentsHandler (PrivateAPI)

- (void)setContents:(NSArray *)value {
    [value retain];
    [contents release];
    contents = value;
}

@end


@implementation ContentsHandler

- (id)init {
	[self setContents:[NSArray array]];
	settingKey = NO;
	
	return self;
}

- (void)awakeFromNib
{
	settingKey = YES;
	if([[theDocument module] isKindOfClass:[SwordBook class]]) {
		[self setContents:[(SwordBook *)[theDocument module] contents]];
		[outlineView reloadData];
	}
	settingKey = NO;
	
	[outlineView setTarget:self];
}

- (void)selectItemForKey:(NSString*)key {
	settingKey = YES;
	// check for an "/" at the beginning of the key
	// if there is one, remove it
	//if([key hasPrefix:@"/"])
	//{
	//	NSString *newKey = [key substringFromIndex:1];
	//	key = newKey;
	//}
	[self selectItemForKey:key parent:contents];
	settingKey = NO;
}

- (void)selectItemForKey:(NSString*)key parent:(NSArray*)parent
{
	NSEnumerator *itemEnum = [parent objectEnumerator];
	id item;
	
	while((item = [itemEnum nextObject]))
	{
		if([item isKindOfClass:[NSArray class]] && [item count] > 0)
		{
			[outlineView expandItem:item];
			[self selectItemForKey:key parent:item];
		}
		else if([item isEqualToString:key])
		{
			//expand parents
			[outlineView selectRow:[outlineView rowForItem:item] byExtendingSelection:NO];
			return;
		}
	}
}

- (void)nextItem
{
	id	row = [outlineView itemAtRow:[outlineView selectedRow]];
	int	nextRow = [outlineView selectedRow] + 1;
	
	if([outlineView isExpandable:row])
	{
		[outlineView expandItem:row];
	}
	
	[outlineView selectRow:nextRow byExtendingSelection:NO];
}

- (void)previousItem
{
	int	nextRow = [outlineView selectedRow] - 1;
	id	row = [outlineView itemAtRow:nextRow];
	
	if([outlineView isExpandable:row])
	{
		[outlineView expandItem:row];
	}
	
	nextRow = [outlineView selectedRow] - 1;
	[outlineView selectRow:nextRow byExtendingSelection:NO];
}

// -------------------------------------------
// NSOutline View delegate methods
// -------------------------------------------
- (void)outlineViewSelectionDidChange:(NSNotification *)aNotification
{
	if(!settingKey)
	{
		id row = [outlineView itemAtRow:[outlineView selectedRow]];
		
		if([row isKindOfClass:[NSArray class]])
		{
			[theDocument openURLString:[row objectAtIndex:0]];
		}
		else
		{
			[theDocument openURLString:row];
		}
	}
}

- (id)outlineView:(NSOutlineView *)outlineView child:(int)index ofItem:(id)item
{
	NSString *ret = nil;
	
	// if no parent return specified category
	if(!item)
	{
		ret = [contents objectAtIndex:index];
	}
	else
	{
		// otherwise return specified module
		ret = [item objectAtIndex:index+1];
	}
	
	return ret;
}

- (BOOL)outlineView:(NSOutlineView *)outlineView isItemExpandable:(id)item
{
	// if it is a category and category contains modules then always yes
	if([item isKindOfClass:[NSArray class]] && [item count] > 0)
	{
		return YES;
	}
	
	// otherwise always no
	return NO;
}

- (int)outlineView:(NSOutlineView *)outlineView numberOfChildrenOfItem:(id)item
{
	// if no parent return number of categories
	if(!item)
	{
		return [contents count];
	}
	else
	{
		return [item count] - 1;
	}
}

- (id)outlineView:(NSOutlineView *)outlineView objectValueForTableColumn:(NSTableColumn *)tableColumn byItem:(id)item
{
	NSArray	*components;
	NSString *name;
	
	if([item isKindOfClass:[NSArray class]])
	{
		name = [item objectAtIndex:0];
	}
	else
	{
		name = item;
	}
	
	components = [name componentsSeparatedByString:@"/"];
	
	return [components lastObject];
}

@end
