//
//  Highlighter.m
//  MacSword
//
//  Created by Manfred Bergmann on 20.06.07.
//  Copyright 2007 mabe. All rights reserved.
//

#import "Highlighter.h"


@implementation Highlighter

+ (NSAttributedString *)highlightText:(NSString *)text forTokens:(NSString *)tokens
{
    NSMutableAttributedString *ret = nil;
    
    NSColor *blue = [NSColor blueColor];
    NSRange found, area;
    unsigned int length = [text length];
    
    if(length > 0)
    {
        // create attributes Dictinary
        NSDictionary *attr = [NSDictionary dictionaryWithObject:blue forKey:NSForegroundColorAttributeName];
        
        // create NSMutableAttributedString
        ret = [[[NSMutableAttributedString alloc] initWithString:text] autorelease];
        
        // remove any characters from the tokens like: "+, -, *, !, &, |, AND, OR, (, ), ""
        NSMutableString *tokenStr = [NSMutableString stringWithString:tokens];
        
        for(int i = 0;i < 11;i++)
        {
            NSString *searchString = @"+";
            switch(i)
            {
                case 0:
                    searchString = @"+";
                    break;
                case 1:
                    searchString = @"-";
                    break;
                case 2:
                    searchString = @"*";
                    break;
                case 3:
                    searchString = @"!";
                    break;
                case 4:
                    searchString = @"&";
                    break;
                case 5:
                    searchString = @"|";
                    break;
                case 6:
                    searchString = @"AND";
                    break;
                case 7:
                    searchString = @"OR";
                    break;
                case 8:
                    searchString = @"(";
                    break;
                case 9:
                    searchString = @")";
                    break;
                case 10:
                    searchString = @"\"";
                    break;
            }
            
            NSRange tFound;
            do
            {
                tFound = [tokenStr rangeOfString:searchString];
                if(tFound.location != NSNotFound)
                {
                    [tokenStr replaceCharactersInRange:tFound withString:@""];
                }
            }
            while(tFound.location != NSNotFound);
        }
        
        // loop over all tokens
        NSArray *tokens = [tokenStr componentsSeparatedByString:@" "];
        int tLen = [tokens count];
        for(int i = 0;i < tLen;i++)
        {
            NSString *token = [tokens objectAtIndex:i];
            
            if(([token length] > 0) && ([token isEqualToString:@" "] == NO))
            {
                // now attribute the string
                area.location = 0;
                area.length = length;
                
                // add new colors
                while(area.length > 0)
                {
                    found = [text rangeOfString:token 
                                        options:NSCaseInsensitiveSearch 
                                          range:area];
                    if (found.location == NSNotFound) break;
                    
                    // set attribute
                    [ret setAttributes:attr range:found];
                    
                    area.location = NSMaxRange(found);
                    area.length = length - area.location;
                }
            }
        }
    }
    
    return ret;
}
    
@end
