/*	FindControl.h - Handles the searching modules

	$Id: FindControl.h,v 1.7 2006/02/02 00:34:04 willthimbleby Exp $
	
	Copyright 2002 Will Thimbleby (wjt100@york.ac.uk)
	
	This program is free software; you can redistribute it and/or modify it under the terms of the
	GNU General Public License as published by the Free Software Foundation version 2.
	
	This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
	even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
	General Public License for more details. (http://www.gnu.org/licenses/gpl.html)
*/

/*
 Manfred Bergmann: added incremental search
 */

#import <Cocoa/Cocoa.h>
#import <CocoLogger/CocoLogger.h>
#import "NSString_Extensions.h"
#import "SwordManager.h"
#import "SwordBible.h"
#import "SwordModule.h"
#import "SwordSearching.h"
#import "IndexingManager.h"
#import "Indexer.h"
#import "SearchResultEntry.h"

typedef enum
{
	regex = 0,
	phrase = -1,
	multiword = -2,
	expression = -3
}SearchMethod;

@interface FindControl : NSWindowController
{
    IBOutlet id rangeEditView;
    IBOutlet id rangePopup;
    IBOutlet id rangeTable;
	
    IBOutlet id indexView;
    IBOutlet id indexProgress;
    IBOutlet id indexInfo;
	
    IBOutlet NSButton *findButton;
    IBOutlet NSButton *ignoreCaseSwitch;
    IBOutlet NSComboBox *inputTextBox;
    IBOutlet id moduleMenu;
    IBOutlet id progressIndicator;
    IBOutlet id typeMenu;
    IBOutlet NSTableView *resultsTable;
    IBOutlet id statusText;
    IBOutlet id findWindow;
	
	NSMutableArray *ranges;

	NSString *searchedFor;
	SearchMethod searchMethod;
	BOOL caseInsensitive;
	NSMutableArray *history;
	BOOL incrementalSearch;

	NSMutableArray *searchResults;
	SwordModule *module;
	
	BOOL searching, indexing;
	NSTimer *liveTimer;
}

- (id)init;
- (void)awakeFromNib;
- (void)updateProgress:(id)progress;
- (void)search:(id)object;
- (void)hiliteResults;
- (void)nameWindow;

- (void)fixPopup;

- (void)createIndexUnthreaded:(id)sender;

// actions
- (IBAction)changeModule:(id)sender;
- (IBAction)doubleClick:(id)sender;
- (IBAction)openFindWindow:(id)sender;
- (IBAction)find:(id)sender;
- (IBAction)editRanges:(id)sender;
- (IBAction)addRange:(id)sender;
- (IBAction)endEditRanges:(id)sender;
- (IBAction)switchIncrementalSearch:(id)sender;

@end

@interface FindTableColumn : NSTableColumn
{
    NSTextFieldCell	*greyCell;
}
@end

@interface FindTable : NSTableView
{
}
- (NSDragOperation)draggingSourceOperationMaskForLocal:(BOOL)isLocal;
@end
