/*	MyDocument.h - Basic document class

	$Id: MyDocument.h,v 1.9 2006/02/02 00:34:19 willthimbleby Exp $
	
	Copyright 2002 Will Thimbleby (wjt100@york.ac.uk)
	
	This program is free software; you can redistribute it and/or modify it under the terms of the
	GNU General Public License as published by the Free Software Foundation version 2.
	
	This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
	even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
	General Public License for more details. (http://www.gnu.org/licenses/gpl.html)
*/

#import <Cocoa/Cocoa.h>
#import <WebKit/WebKit.h>

#import "AppDelegate.h"
#import "SwordBible.h"
#import "ContentsHandler.h"
#import "BookmarkHandler.h"
#import "EditView.h"

@class ContentsHandler, BookmarkHandler, ModuleToolbarView;

@interface MyDocument : NSDocument {
    IBOutlet WebView *webView;
	IBOutlet NSWindow *myWindow;
	
	//toolbar outlets
    IBOutlet NSTextField *urlBar;
    IBOutlet NSView *simpleBibleView;
    IBOutlet NSView *referenceView;
    IBOutlet NSView *devotionalView;
    IBOutlet NSView *dictView;
	
    IBOutlet ModuleToolbarView *moduleView;
    IBOutlet NSPopUpButton *modulePopup;
	
	IBOutlet NSButton *backButton;
	IBOutlet NSButton *forwardButton;
	
	IBOutlet NSComboBox *monthCombo;
	IBOutlet NSComboBox *dayCombo;
	IBOutlet NSComboBox *dictCombo;
	IBOutlet NSComboBox *bookCombo;
	IBOutlet NSComboBox *chapterCombo;
	
	//drawers
	IBOutlet NSDrawer *contentsDrawer;
	IBOutlet ContentsHandler *contentsHandler;
	IBOutlet NSDrawer *bookmarkDrawer;
	IBOutlet BookmarkHandler *bookmarkHandler;
	
	// reference entering
	IBOutlet NSTextField *referenceTextField;
	
	EditView *editView;
	NSScrollView *editScrollView;

	NSToolbar *toolbar;
	
	//IBOutlet id optionsMenu;
	NSString *tag;
	SwordModule	*module;
	ModuleType type;
	NSURL *url;
	
	NSMutableDictionary *displayOptions;
	
	int trackingTag;
	
	BOOL isEditing;
	BOOL windowClosing;
}


+ (MyDocument *)openDocumentWithSavedDoc:(NSDictionary*)doc;
+ (MyDocument *)openDocumentWithURLString:(NSString*)aURLString;
+ (MyDocument *)openDocumentWithURL:(NSURL*)aURL;

- (id)initWithContentsOfURL:(NSURL *)aURL ofType:(NSString *)docType;
- (id)initWithURL:(NSURL*)aURL;
- (BOOL)readFromFile:(NSString *)fileName ofType:(NSString *)docType;

- (NSString *)windowNibName;
- (void)windowControllerDidLoadNib:(NSWindowController *) aController;
- (void)windowWillClose:(NSNotification *)notification;
- (void)dealloc;
- (BOOL)isDocumentEdited;
- (void)printShowingPrintPanel:(BOOL)showPanels;

- (ModuleType)type;
- (NSDictionary *)displayOptions;
- (void)setDisplayOptions:(NSDictionary *)value;
- (NSWindow *)window;
- (NSURL *)url;
- (void)setURL:(NSURL *)u;
- (id)webView;
- (SwordModule *)module;
- (void)setTag:(NSString*)t;
- (NSString *)getTag;
- (void)setReference:(NSString *)aRef;
- (NSString *)reference;
- (NSDictionary *)saveInfo;

- (int)numberOfItemsInComboBox:(NSComboBox *)aComboBox;
- (id)comboBox:(NSComboBox *)aComboBox objectValueForItemAtIndex:(int)index;

- (IBAction)nextChapter:(id)sender;
- (IBAction)previousChapter:(id)sender;
- (IBAction)nextBook:(id)sender;
- (IBAction)previousBook:(id)sender;
- (IBAction)toggleBookmarks:(id)sender;

- (IBAction)changeEntry:(id)sender;
- (IBAction)changeDate:(id)sender;
- (IBAction)changeChapter:(id)sender;
- (IBAction)changeBook:(id)sender;
- (IBAction)changeModule:(id)sender;
- (IBAction)connectURL:(id)sender;
- (IBAction)referenceEntered:(id)sender;

- (void)openURLString:(NSString *)urlString;
- (void)changeModuleTo:(NSString *)module;

- (void)updateWindow;
- (void)updateToolbar;
- (void)updateCombos;

- (BOOL)validateMenuItem:(NSMenuItem *)anItem;
- (void)setState:(id)sender option:(NSString *)option;
- (void)getState:(id)sender option:(NSString *)option;
- (void)setOption:(id)sender;
- (void)fixOptionsMenu;
- (void)fixVariants;

- (void)webView:(WebView *)sender didStartProvisionalLoadForFrame:(WebFrame *)frame;
- (void)webView:(WebView *)sender didReceiveTitle:(NSString *)title forFrame:(WebFrame *)frame;
- (void)webView:(WebView *)sender didFinishLoadForFrame:(WebFrame *)frame;
- (void)webView:(WebView *)sender didFailProvisionalLoadWithError:(NSError *)error forFrame:(WebFrame *)frame;

- (WebView *)webView:(WebView *)sender createWebViewWithRequest:(NSURLRequest *)request;

- (void)webView:(WebView *)sender mouseDidMoveOverElement:(NSDictionary *)elementInformation modifierFlags:(id)modifierFlags;
- (void)setupTrackingRect;
- (void)windowDidResize:(NSNotification *)aNotification;
- (void)mouseEntered:(NSEvent *)theEvent;
- (void)mouseExited:(NSEvent *)theEvent;
- (NSArray *)webView:(WebView *)sender contextMenuItemsForElement:(NSDictionary *)element defaultMenuItems:(NSArray *)defaultMenuItems;

- (void)webView:(WebView *)sender decidePolicyForNavigationAction:(NSDictionary *)actionInformation request:(NSURLRequest *)request frame:(WebFrame *)frame decisionListener:(id<WebPolicyDecisionListener>)listener;
- (void)webView:(WebView *)sender decidePolicyForNewWindowAction:(NSDictionary *)actionInformation request:(NSURLRequest *)request newFrameName:(NSString *)frameName decisionListener:(id<WebPolicyDecisionListener>)listener;

@end
