//
//  MyDocument(Edit).m
//  MacSword
//
//  Created by William Thimbleby on Sat Jan 29 2005.
//  Copyright (c) 2005 __MyCompanyName__. All rights reserved.
//

#import "MyDocument(Edit).h"
#import "EditView.h"
#import "EditTextView.h"


@implementation MyDocument(Edit)

- (IBAction)toggleEdit:(id)sender
{
	if(!isEditing && [self canEdit])
		[self startEdit];
	else
		[self endEdit];
}

- (BOOL)canEdit
{
	return [[module getConfigEntry:@"Editable"] isEqualToString:@"YES"] || [[module getConfigEntry:@"Description"] isEqualToString:@"Personal Commentary"];
}

- (void)startEdit
{
	if(!editView)
	{
		editScrollView = [[NSScrollView alloc] initWithFrame:NSMakeRect(0,0,400,500)];
		[editScrollView setHasVerticalScroller:YES];
		
		NSSize cs = [editScrollView contentSize];
		editView = [[EditView alloc] initWithFrame:NSMakeRect(0,0,cs.width,cs.height)];
		[editScrollView setDocumentView:editView];
		[editView release];
	}
	
	[editScrollView retain];
	[webView retain];
	
	[myWindow setContentView:editScrollView];	
	[myWindow makeKeyAndOrderFront:self];
	
	[editView setURL:[self url]];
	
	isEditing = YES;
	
	[editView setNeedsDisplay:YES];
	
/*	if(!editView)
	{
		editScrollView = [[NSScrollView alloc] initWithFrame:NSMakeRect(0,0,400,500)];
		[editScrollView setHasVerticalScroller:YES];
		
		NSSize cs = [editScrollView contentSize];
		editView = [[EditTextView alloc] initWithFrame:NSMakeRect(0,0,cs.width,cs.height)];
		[editScrollView setDocumentView:editView];
	}
	[webView retain];
	[myWindow setContentView:editScrollView];
	[editScrollView release];
	
	[myWindow makeKeyAndOrderFront:self];
	
	[editView setURL:[self url]];
	
	isEditing = YES;*/
}

- (void)close
{
	NSLog(@"close Edit");
	//if(isEditing) [self endEdit];
	[myWindow makeFirstResponder:nil];
	if(editView)//have edited
	{
		[webView release];
		[editScrollView release];
	}
	[super close];
}

- (void)endEdit
{
	NSLog(@"end Edit");
	
	[myWindow makeFirstResponder:nil];
	[webView reload:self];
	[myWindow setContentView:webView];
	
	isEditing = NO;
}

@end
