//
//  ToolTip.m
//  MacSword
//
//  Created by Will Thimbleby on Mon Jan 12 2004.
//  Copyright (c) 2004 Will Thimbleby. All rights reserved.
//

#import "ToolTip.h"

ToolTip		*tipDisplayed = NULL;
id			tipObject = NULL;

NSRect MoveRectInto(NSRect move, NSRect into)
{
	if(move.origin.x+move.size.width > into.origin.x+into.size.width)
		move.origin.x -= (move.origin.x+move.size.width) - (into.origin.x+into.size.width);
	if(move.origin.y+move.size.height > into.origin.y+into.size.height)
		move.origin.y -= (move.origin.y+move.size.height) - (into.origin.y+into.size.height);
		
	if(move.origin.x < into.origin.x)
		move.origin.x = into.origin.x;
	if(move.origin.y < into.origin.y)
		move.origin.y = into.origin.y;
	
	return move;
}

@implementation ToolTip

+ (BOOL) willDisplayToolTipForObject:(id)object
{
	if(![[[NSUserDefaults standardUserDefaults] objectForKey:@"tool tips"] boolValue])
		return NO;
		
	// displaying a invalid tip
	if(object == NULL)
	{
		return NO;
	}
	
	// displaying the same tip as is already shown
	if(tipDisplayed && tipObject && [tipObject isEqualTo:object])
	{
		return NO;
	}
	
	return YES;
}

+ (void) displayToolTip:(NSString*)tipText forObject:(id)object atPoint:(NSPoint)position forWindow:(NSWindow*)wind
{
	ToolTip					*newToolTip;
	
	if(![[[NSUserDefaults standardUserDefaults] objectForKey:@"tool tips"] boolValue])
		return;
	
	// displaying a invalid tip
	if(object == NULL)
	{
		// if displaying a tip already fade it out
		if(tipDisplayed)
		{
			[tipDisplayed disappear:NULL];
		}
		
		return;
	}
	
	// displaying the same tip as is already shown
	if(tipDisplayed && tipObject && [tipObject isEqualTo:object])
	{
		return;
	}
	
	// displaying a tip when one is already shown
	if(tipDisplayed)
		[tipDisplayed close];
	
	[tipObject autorelease];
	tipObject = [object retain];
	
	// create the tip
	newToolTip = [ToolTip createToolTip:tipText atPoint:position];
	//toolTipControl = [[NSWindowController alloc] initWithWindow:newToolTip];
		
	[newToolTip orderFront:wind];
   // [wind addChildWindow:newToolTip ordered:NSWindowAbove];
	
	// display it
	//[toolTipControl showWindow:newToolTip];
}

+ (id)createToolTip:(NSString*)tipText atPoint:(NSPoint)position
{
	ToolTip			*tt;
	NSTextView		*textView;
	
	// create text field for tip
	textView = [[NSText alloc] initWithFrame:NSMakeRect(0,0,300,300)];
	[textView setSelectable:NO];
	[textView setMaxSize:NSMakeSize(300,600)];
	[textView setMinSize:NSMakeSize(5,5)];
	[textView setVerticallyResizable:YES];
	[textView setHorizontallyResizable:YES];
	
	//add it to the window, make orange and set text
	[textView setBackgroundColor: [NSColor colorWithCalibratedRed:1.0 green:0.9 blue:0.8 alpha:1]];
	[textView setString:tipText];
	[textView sizeToFit];
	{
		NSSize size=[textView frame].size;
		size.height+=2;
		[textView setFrameSize:size];
	}
		
	if ((tt = [[ToolTip alloc] initWithContentRect:NSMakeRect(position.x, position.y-16-[textView bounds].size.height, [textView bounds].size.width, [textView bounds].size.height)
                     styleMask:NSBorderlessWindowMask
                     backing:NSBackingStoreBuffered
					 defer:YES]))
	{
		NSRect		tipRect;
		
		//setup window with shadow at correct level not in menu
		[tt setHasShadow:YES];
		[tt setLevel:NSStatusWindowLevel];
		[tt setIgnoresMouseEvents:YES];
		[tt setExcludedFromWindowsMenu:YES];
		[tt setHidesOnDeactivate:YES];
		
		//destroy when closed
		[tt setReleasedWhenClosed:YES];
		
		
		//we are not disappearing yet
		[tt setDisapperaing:NO];
		
		//fit it on screen
		tipRect = MoveRectInto([tt frame], [[tt screen] frame]);
		[tt setFrame:tipRect display:NO];
		
		//add text into it
		[tt setContentView:textView];
		
		//timer = [NSTimer scheduledTimerWithTimeInterval:5 target:self selector:@selector(disappear:) userInfo:NULL repeats:NO];
		tipDisplayed = tt;
	}
	
	return tt;
}

- (void)dealloc
{
	[timer invalidate];
	[super dealloc];
}

- (void)setDisapperaing:(BOOL)d
{
	disappearing = d;
}

- (void)disappear:(id)data
{
	if(!disappearing)
		[NSThread detachNewThreadSelector:@selector(disappearThread:) toTarget:self withObject:data];
	
	disappearing = YES;
}

- (void)disappearThread:(id)data
{
	NSAutoreleasePool	*pool = [[NSAutoreleasePool alloc] init];
	float				alpha;
	
	for(alpha=1;alpha > 0; alpha -= 0.05)
	{
		[self setAlphaValue:alpha];
		[NSThread sleepUntilDate:[NSDate dateWithTimeIntervalSinceNow:0.025]];
	}
	
	[self close];
	if(self == tipDisplayed)
		tipDisplayed = NULL;
	[pool release];
}

@end
