/*	OutlineViewPlus.m

	$Id: OutlineViewPlus.m,v 1.4 2006/02/02 00:18:41 willthimbleby Exp $
	
	Copyright 2003 Will Thimbleby (will@thimbleby.net)
	
	This program is free software; you can redistribute it and/or modify it under the terms of the
	GNU General Public License as published by the Free Software Foundation version 2.
	
	This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
	even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
	General Public License for more details. (http://www.gnu.org/licenses/gpl.html)
*/

#import "OutlineViewPlus.h"


@implementation OutlineViewPlus

- (void)mouseDown:(NSEvent *)event 
{
	id		item;
	
	// on double click make the rows expand collapse
	item = [self itemAtRow:[self rowAtPoint:[self convertPoint:[event locationInWindow] fromView:nil]]];
	
	if([event clickCount] == 2 && [self isExpandable:item])
	{
		if([self isItemExpanded:item])
			[self collapseItem:item];
		else
			[self expandItem:item];
	}
	
	[super mouseDown:event];
}

- (void)keyDown:(NSEvent *)event 
{
	unichar		key;
	BOOL		done = NO;

    key = [[event characters] characterAtIndex:0];
	
	switch (key)
	{
		case NSRightArrowFunctionKey:
			if([self selectedRow] >= 0)
			{
				if([self isExpandable:[self itemAtRow:[self selectedRow]]])
				{
					[self expandItem:[self itemAtRow:[self selectedRow]]];
					done = YES;
				}
			}
			break;
		case NSLeftArrowFunctionKey:
			if([self selectedRow] >= 0)
			{
				if([self isExpandable:[self itemAtRow:[self selectedRow]]])
				{
					[self collapseItem:[self itemAtRow:[self selectedRow]]];
					done = YES;
				}
			}
			break;
	}
	
	if(!done)
		[super keyDown:event];
}

@end
