//
//  NSColor_Extensions.m
//  MacSword
//
//  Created by Will Thimbleby on Fri Jan 09 2004.
//  Copyright (c) 2004 Will Thimbleby. All rights reserved.
//

#import "NSColor_Extensions.h"
#include <stdio.h>

@implementation NSColor (MyExtensions)

+ (NSColor *) colorWithHtmlString:(NSString*)html
{
	float			r, g, b;
	int				rc, gc, bc;
	
	if(!html)
		return [NSColor magentaColor];
	
	sscanf([html cString], "%2X%2X%2X", &rc, &gc, &bc);
	
	r = (float)rc/255;
	b = (float)bc/255;
	g = (float)gc/255;
	
	return [NSColor colorWithCalibratedRed:r green:g blue:b alpha:1];
}

- (NSString *) htmlString
{
	float				r, g, b, a;
	unsigned char		rc, gc, bc;
	NSColor				*rgbColor;
	
	rgbColor = [self colorUsingColorSpaceName:NSCalibratedRGBColorSpace];
	[rgbColor getRed:&r green:&g blue:&b alpha:&a];
	
	rc = 255*r;
	gc = 255*g;
	bc = 255*b;
	
	return [NSString stringWithFormat:@"%02X%02X%02X", rc, gc, bc];
}

@end
