/*	BookmarkOutlineView.m

	$Id: BookmarkOutlineView.m,v 1.2 2006/02/02 00:18:34 willthimbleby Exp $
	
	Copyright 2003 Will Thimbleby (will@thimbleby.net)
	
	This program is free software; you can redistribute it and/or modify it under the terms of the
	GNU General Public License as published by the Free Software Foundation version 2.
	
	This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
	even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
	General Public License for more details. (http://www.gnu.org/licenses/gpl.html)
*/

#import "BookmarkOutlineView.h"
#import "BookmarkHandler.h"
#import "NSOutlineView_Extensions.h"

@implementation BookmarkOutlineView

- (void)mouseDown:(NSEvent *)event 
{
	_clickedRow = [self rowAtPoint:[self convertPoint:[event locationInWindow] fromView:nil]];
	_clickedColumn = [self columnAtPoint:[self convertPoint:[event locationInWindow] fromView:nil]];
	
	// make sure editing doesn't start
	[[[self tableColumns] objectAtIndex:0] setEditable:NO];
	[[[self tableColumns] objectAtIndex:1] setEditable:NO];
	
	[super mouseDown:event];
		
	// re-allow editing
	[[[self tableColumns] objectAtIndex:0] setEditable:YES];
	[[[self tableColumns] objectAtIndex:1] setEditable:YES];
}

- (void)keyDown:(NSEvent *)event 
{
	unichar		key;
	BOOL		done = NO;

    key = [[event characters] characterAtIndex:0];
	
	switch (key)
	{
		case NSDeleteFunctionKey:
		case NSDeleteCharFunctionKey:
		case '\177': // Delete
		case '\b': // Backspace
			[(BookmarkHandler*)[self dataSource] deleteItems:[self allSelectedItems]];
			done = YES;
			break;
		case '\r': // Carriage return
		case '\n': // Newline
			[self edit];
			break;
		case 'a':
			[self abortEditing];
	}
	
	if(!done)
		[super keyDown:event];
}

- (void)editReference
{
	_clickedColumn = [self columnWithIdentifier:@"reference"];
	[self edit];
}

- (void)editBookmark
{
	_clickedColumn = [self columnWithIdentifier:@"bookmark"];
	[self edit];
}

- (void)edit
{
	if([self editedRow])
		[self abortEditing];
	if([self selectedRow] >= 0)
	{
		[self selectRow:_clickedRow byExtendingSelection:NO];
		[self editColumn:_clickedColumn row:_clickedRow withEvent:NULL select:YES];
	}
}

- (void)editColumn:(int)columnIndex row:(int)rowIndex withEvent:(NSEvent *)theEvent select:(BOOL)flag
{
	// if we are trying to select the reference of a group
	// select the next item
	
	if(columnIndex == 1 && [self isExpandable:[self itemAtRow:rowIndex]])
	{
		if(rowIndex < [self numberOfRows]-1)
			rowIndex++;
		else
			rowIndex = 0;
			
		[self selectRow:rowIndex byExtendingSelection:NO];
		[super editColumn:0 row:rowIndex withEvent:theEvent select:flag];
	}
	else
		[super editColumn:columnIndex row:rowIndex withEvent:theEvent select:flag];
}
@end
