/*	BookmarkHandler.h - Handles the bookmark outline view

	$Id: BookmarkHandler.h,v 1.2 2006/02/02 00:33:50 willthimbleby Exp $
	
	Copyright 2003 Will Thimbleby (wjt100@york.ac.uk)
	
	This program is free software; you can redistribute it and/or modify it under the terms of the
	GNU General Public License as published by the Free Software Foundation version 2.
	
	This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
	even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
	General Public License for more details. (http://www.gnu.org/licenses/gpl.html)
*/

#import <Cocoa/Cocoa.h>
#import "Bookmark.h"
#import "TreeNode.h"
#import "MyDocument.h"
#import "BookmarkOutlineView.h"

@class MyDocument;

@interface ColourTableColumn : NSTableColumn
{
	id colorCell;
	id blankCell;
}

@end


@interface BookmarkHandler : NSObject
{
	TreeNode *treeData;
	NSArray *draggedNodes;
	
	IBOutlet BookmarkOutlineView *outlineView;
	IBOutlet MyDocument	*theDocument;
	IBOutlet NSPopUpButton *actionButton;
	IBOutlet NSMenu *bookmarkMenu;
}

+ (NSString *)allBookmarks:(int)colour;
+ (NSString *)_allBookmarks:(NSArray*)array :(int)colour;

- (id)init;
- (void)dealloc;

- (void)save;
- (void)update:(id)sender;

- (void)setName:(NSArray*)data;
- (void)setReference:(NSArray*)data;

- (IBAction)addBookmark:(id)sender;
- (IBAction)addGroup:(id)sender;

- (void)deleteItems:(NSArray*)items;

- (void)_addNewDataToSelection:(BookmarkTreeNode *)newChild;
@end
