/*	Bookmark.m

	$Id: Bookmark.m,v 1.2 2006/02/02 00:18:34 willthimbleby Exp $
	
	Copyright 2003 Will Thimbleby (will@thimbleby.net)
	
	This program is free software; you can redistribute it and/or modify it under the terms of the
	GNU General Public License as published by the Free Software Foundation version 2.
	
	This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
	even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
	General Public License for more details. (http://www.gnu.org/licenses/gpl.html)
*/

#import "Bookmark.h"
#import "BookmarkHandler.h"


@implementation BookmarkNodeData

+ (id)leafDataWithName:(NSString*)str forReference:(NSString*)ref withColour:(NSNumber*)col
{
    // Convenience method to return a leaf node with its name set.
    return [[[BookmarkNodeData alloc] initWithName:str forReference:ref withColour:col isGroup:NO] autorelease];
}

+ (id)groupDataWithName:(NSString*)str
{
    // Convenience method to return a branch node with its name set.
    return [[[BookmarkNodeData alloc] initWithName:str forReference:NULL withColour:NULL isGroup:YES] autorelease];
}

- (id)initWithName:(NSString*)n forReference:(NSString*)ref  withColour:(NSNumber*)col isGroup:(BOOL)group
{
	self = [super init];
	
	[self setName:n];
	[self setReference:ref];
	[self setGroup:group];
	//[self setColour:col];
	
	colour = [col retain];
	
	return self;
}

- (NSString *)name
{
	return name;
}

- (void)setName:(NSString *)aName
{
	if (name != aName)
	{
		[name release];
		name = [aName retain];
	}
}

- (NSString *)reference
{
	return reference;
}

- (void)setReference:(NSString *)aReference
{
	if (reference != aReference)
	{
		[reference release];
		reference = [aReference retain];
	}
}

- (NSNumber *)colour
{
	return colour;
}

- (void)setColour:(int)c
{
	[colour release];
	colour = [[NSNumber numberWithInt:c] retain];
}

- (BOOL)isGroup
{
	return isGroup;
}

- (void)setGroup:(BOOL)group
{
	isGroup = group;
}

@end

#pragma mark -

@implementation BookmarkTreeNode

+ (id)treeNodeWithData:(TreeNodeData*)data {
    return [[[BookmarkTreeNode alloc] initWithData: data  parent:nil children:[NSArray array]] autorelease]; 
}

- (id) initFromArray:(NSArray*)array
{
	// This is a convenience init method to return a tree root of a tree derived from an input dictionary.
	// The input dictionary for this example app is InitInfo.dict.  Look at that file to understand the format.
	BookmarkNodeData	*data = [BookmarkNodeData groupDataWithName: [array objectAtIndex:0]];
	NSEnumerator		*entryEnum = [array objectEnumerator];
	id					entry;
	BookmarkTreeNode	*child = nil;
	
	self = [super initWithData:data parent:nil children:[NSArray array]];
	if (self==nil) return nil;
	
	[entryEnum nextObject];
	while((entry = [entryEnum nextObject]))
	{
		if ([entry isKindOfClass: [NSArray class]])
			child = [BookmarkTreeNode treeFromArray: entry];
		else 
			child = [[[BookmarkTreeNode alloc] initWithData:[BookmarkNodeData leafDataWithName:[entry objectForKey:@"name"] forReference:[entry objectForKey:@"reference"] withColour:[entry objectForKey:@"colour"]] parent:nil children: [NSArray array]] autorelease];
		[self insertChild: child atIndex: [self numberOfChildren]];
	}
	
	return self;
}

+ (id) treeFromArray:(NSArray*)array
{
    return [[[BookmarkTreeNode alloc] initFromArray:array] autorelease];
}

- (NSArray*) arrayFromTree
{
	NSMutableArray		*theArray = [NSMutableArray arrayWithObject:[(BookmarkNodeData*)[self nodeData] name]];
	NSEnumerator		*childEnum;
	BookmarkTreeNode	*child;
	
	childEnum = [[self children] objectEnumerator];
	
	while((child = [childEnum nextObject]))
	{
		if([(BookmarkNodeData*)[child nodeData] isGroup])
		{
			[theArray addObject:[child arrayFromTree]];
		}
		else
		{
			[theArray addObject:[NSDictionary dictionaryWithObjectsAndKeys:[(BookmarkNodeData*)[child nodeData] name], @"name", [(BookmarkNodeData*)[child nodeData] reference], @"reference", [(BookmarkNodeData*)[child nodeData] colour], @"colour", NULL]];
		}
	}
	
	return theArray;
}

@end

