/*	Bookmark.h

	$Id: Bookmark.h,v 1.2 2006/02/02 00:30:37 willthimbleby Exp $
	
	Copyright 2003 Will Thimbleby (wjt100@york.ac.uk)
	
	This program is free software; you can redistribute it and/or modify it under the terms of the
	GNU General Public License as published by the Free Software Foundation version 2.
	
	This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
	even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
	General Public License for more details. (http://www.gnu.org/licenses/gpl.html)
*/

#import <Foundation/Foundation.h>
#import "TreeNode.h"


@interface BookmarkNodeData : TreeNodeData
{
	NSString		*name;
	NSString		*reference;
	NSNumber		*colour;
	id				data;
	
	BOOL			isGroup;
}

+ (id)leafDataWithName:(NSString*)str forReference:(NSString*)ref withColour:(NSNumber*)col;
+ (id)groupDataWithName:(NSString*)str;
- (id)initWithName:(NSString*)n forReference:(NSString*)ref  withColour:(NSNumber*)col isGroup:(BOOL)group;

- (NSString *)name;
- (void)setName:(NSString *)aName;
- (NSString *)reference;
- (void)setReference:(NSString *)aReference;
- (BOOL)isGroup;
- (void)setGroup:(BOOL)group;
- (NSNumber *)colour;
- (void)setColour:(int)aColour;
- (id)data;
- (void)setData:(id)theData;

@end

@interface BookmarkTreeNode : TreeNode
{
}

+ (id) treeFromArray:(NSArray*)array;
- (id) initFromArray:(NSArray*)array;
- (NSArray*) arrayFromTree;

@end