#import "EditView.h"
#import "SwordServer.h"
#import "utils.h"

@implementation EditView

// Globals
BOOL initHTMLReader = NO;

NSFont *normalFont;
NSFont *italicFont;
NSFont *boldFont;
NSFont *italicBoldFont;

NSFont *fontArray[2][2];


- (id)initWithFrame:(NSRect)frameRect
{
	if ((self = [super initWithFrame:frameRect]) != nil)
	{
		
		textViews = [[NSMutableArray array] retain];
		labels = [[NSMutableArray array] retain];
		
		// init fonts
		normalFont = [[NSFont userFontOfSize:14] retain];
		italicFont = [[[NSFontManager sharedFontManager] convertFont:normalFont toHaveTrait:NSItalicFontMask] retain];
		boldFont = [[[NSFontManager sharedFontManager] convertFont:normalFont toHaveTrait:NSBoldFontMask] retain];
		italicBoldFont = [[[NSFontManager sharedFontManager] convertFont:italicFont toHaveTrait:NSBoldFontMask] retain];
		
		fontArray[0][0]=normalFont; fontArray[0][1]=italicFont; fontArray[1][0]=boldFont; fontArray[1][1]=italicBoldFont;		
		
		//sword::VerseKey		vk;
		//sword::ListKey listkey = vk.ParseVerseList(toUTF8(@"mark1"), "gen1", true);
		
		//[self setReferences:&listkey module:[[SwordManager defaultManager] moduleWithName:@"Personal"]];
		
		[[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(frameDidChange:) name:NSViewFrameDidChangeNotification object:nil];
		
		[self setAutoresizingMask: NSViewWidthSizable];
	}
	return self;
}

- (void)dealloc
{
	[[NSNotificationCenter defaultCenter] removeObserver:self];
	//[self writeAll];
	[textViews release];
	[labels release];
	
	// release all fonts
	[normalFont release];
	[italicFont release];
	[boldFont release];
	[italicBoldFont release];
	
	[super dealloc];
}

- (void)textDidEndEditing:(NSNotification *)aNotification
{
	int i = [textViews indexOfObject:[aNotification object]];
	
	[self writeEntry:i];
}

- (void)writeAll
{
	unsigned			i;
	
	if(![[module getConfigEntry:@"Editable"] isEqualToString:@"YES"]) return;
	
	for(i=0;i<[textViews count];i++)
	{
		NSTextView		*contents = [textViews objectAtIndex:i];
		NSTextField		*label = [labels objectAtIndex:i];
		
		[module writeEntry:[contents string] forRef:[label stringValue]];
	}
}

- (void)writeEntry:(int)i
{
	if(![[module getConfigEntry:@"Editable"] isEqualToString:@"YES"]) return;
	if(i < 0 || i >= [textViews count]) return;
	
	NSTextView		*contents = [textViews objectAtIndex:i];
	NSTextField		*label = [labels objectAtIndex:i];
	
	NSAttributedString *text = [contents textStorage];
	int index = 0, size = [text length];
	NSRange maxRange = NSMakeRange(0, size);
	BOOL bold, italic, underline;
	NSMutableString *html = [NSMutableString string];
	
	[html replaceOccurrencesOfString:@"<" withString:@"&lt;" options:NSLiteralSearch range:NSMakeRange(0, [html length])];
	[html replaceOccurrencesOfString:@">" withString:@"&gt;" options:NSLiteralSearch range:NSMakeRange(0, [html length])];
	
	bold = italic = underline = NO;
	while(index < size)
	{
		NSRange aRange, uRange;
		
		NSDictionary *dict = [text attributesAtIndex:index longestEffectiveRange:&aRange inRange:maxRange];
		NSFont *f = [dict objectForKey:NSFontAttributeName];
		NSNumber *u = [dict objectForKey:NSUnderlineStyleAttributeName];
		
		NSFontTraitMask fontTraits = [[NSFontManager sharedFontManager] traitsOfFont:f];
		
		if(NSBoldFontMask & fontTraits && !bold) [html appendString:@"<b>"];
		else if(!(NSBoldFontMask & fontTraits) && bold) [html appendString:@"</b>"];
		if(NSItalicFontMask & fontTraits && !italic) [html appendString:@"<i>"];
		else if(!(NSItalicFontMask & fontTraits) && italic) [html appendString:@"</i>"];
		
		bold = (NSBoldFontMask & fontTraits);
		italic = (NSItalicFontMask & fontTraits);
		
		if(!underline && [u intValue] > 0)
		{
			[text attribute:NSUnderlineStyleAttributeName atIndex:index longestEffectiveRange:&uRange inRange:maxRange];
			NSString *ref = [[text attributedSubstringFromRange:uRange] string];
			if([ref hasPrefix:@"sword://"] || [ref hasPrefix:@"//"])
				[html appendString:[NSString stringWithFormat:@"<a href=\"%@\">", ref]];
			else
				[html appendString:[NSString stringWithFormat:@"<a href=\"///%@\">", ref]];
			underline = YES;
		}
		else if(underline && [u intValue] == 0)
		{
			[html appendString:@"</a>"];
			underline = NO;
		}
		
		[html appendString:[[text attributedSubstringFromRange:aRange] string]];
		
		index = aRange.location + aRange.length;
	}
	[html replaceOccurrencesOfString:@"\n" withString:@"<br>" options:NSLiteralSearch range:NSMakeRange(0, [html length])];
	[module writeEntry:html forRef:[label stringValue]];
}

- (void)setURL:(NSURL*)url
{
	SwordModule *smodule = [[SwordManager defaultManager] moduleForURL:url];
	NSString *ref = [SwordServer referenceForURL:url];
	
	//remove
	for(int i=0;i<[textViews count];i++)
	{
		NSTextView		*theTextView = [textViews objectAtIndex:i];
		NSTextField		*theTextField = [labels objectAtIndex:i];
		[theTextView removeFromSuperview];
		[theTextField removeFromSuperview];
	}
	[textViews release];
	[labels release];
	textViews = [[NSMutableArray array] retain];
	labels = [[NSMutableArray array] retain];
	
	sword::VerseKey		vk;
	sword::ListKey listkey = vk.ParseVerseList(toUTF8(ref), "gen1", true);
	
	[self setReferences:&listkey module:smodule];
	[self reframe];
}

- (NSAttributedString*)readBasicHTML:(NSString*)html
{
	NSScanner *scan = [NSScanner scannerWithString:html];
	[scan setCharactersToBeSkipped:[NSCharacterSet illegalCharacterSet]];
	
	NSString *string, *token;
	NSMutableAttributedString *result = [[NSMutableAttributedString alloc] init];
	
	
	if(!initHTMLReader)
	{
		// font are now initialized on init
		initHTMLReader = YES;
	}
	
	int bold=0, italic=0;
	
	NSMutableDictionary *currentAttributes = [NSMutableDictionary dictionaryWithObject:normalFont forKey:NSFontAttributeName];
	
	while(![scan isAtEnd])
	{
		if([scan scanUpToString:@"<" intoString:&string])
		{
			NSAttributedString *attrString = [[NSAttributedString alloc] initWithString:string attributes:currentAttributes];
			[result appendAttributedString:attrString];
		}
		
		
		[scan scanString:@"<" intoString:NULL];
		BOOL b = [scan scanUpToString:@">" intoString:&token];
		if(!b) break;
		[scan scanString:@">" intoString:NULL];
		
		
		NSLog(token);
		
		if([token isEqualToString:@"i"])
			italic = 1;
		else if([token isEqualToString:@"/i"])
			italic = 0;
		else if([token isEqualToString:@"b"])
			bold = 1;
		else if([token isEqualToString:@"/b"])
			bold = 0;
		else if([token hasPrefix:@"a"])
			[currentAttributes setObject:[NSNumber numberWithInt:1] forKey:NSUnderlineStyleAttributeName];
		else if([token isEqualToString:@"/a"])
			[currentAttributes setObject:[NSNumber numberWithInt:0] forKey:NSUnderlineStyleAttributeName];
		
		[currentAttributes setObject:fontArray[bold][italic] forKey:NSFontAttributeName];
	}
	
	NSMutableString *resultString = [result mutableString];
	[resultString replaceOccurrencesOfString:@"&lt;" withString:@"<" options:NSLiteralSearch range:NSMakeRange(0, [resultString length])];
	[resultString replaceOccurrencesOfString:@"&gt;" withString:@">" options:NSLiteralSearch range:NSMakeRange(0, [resultString length])];
	
	return result;
}

- (void)setReferences:(sword::ListKey*)listkey module:(SwordModule*)mod
{
	int					i, c, lastIndex;
	sword::SWModule		*swmodule;
	
	module = mod;
	swmodule = [module swmodule];
	
	c = listkey->Count();
	for (i = 0; i < c; i++)
	{
		sword::VerseKey *element = My_SWDYNAMIC_CAST(VerseKey, listkey->GetElement(i));
		sword::VerseKey vk;
		
		// is it a chapter or book - not atomic
		if(element)
		{
			// start at lower bound
			swmodule->Key(element->LowerBound());
			// find the upper bound
			vk = element->UpperBound();
			vk.Headings();
		}
		else
		{
			// set it up
			swmodule->Key(*(listkey->GetElement(i)));
		}
			
		// while not past the upper bound
		do
		{
			const char *text = swmodule->RenderText();
			
			if(strlen(text))
			{
				/*NSString *finfo = @"<font face=\"sans-serif\" size=\"4\">", *fend=@"</font>";
				NSMutableData *d = [NSMutableData dataWithBytes:[finfo cString] length:[finfo length]];
				[d appendData:[NSData dataWithBytes:text length:strlen(text)]];
				[d appendData:[NSData dataWithBytes:[fend cString] length:[fend length]]];
				
				NSMutableAttributedString *html = [[[NSMutableAttributedString alloc] initWithHTML:d documentAttributes:nil] autorelease];
				[html removeAttribute:NSLinkAttributeName range:NSMakeRange(0,[html length])];
				[html removeAttribute:NSForegroundColorAttributeName range:NSMakeRange(0,[html length])];
				[html fixAttributesInRange:NSMakeRange(0,[html length])];*/
				
				NSMutableAttributedString *html = [self readBasicHTML:[NSString stringWithUTF8String:text]];
				
				/*NSMutableAttributedString *html2 = [[NSMutableAttributedString alloc] init];
				[html2 setTypingAttributes:htmlDocAttr];
				[html2 appendAttributedString:html];html = html2;
				NSLog(@"%@",[NSFont systemFontOfSize:0]);*/
				[self createRef:[NSString stringWithUTF8String:swmodule->Key().getText()] withContent:html];
				//[self createRef:[NSString stringWithUTF8String:swmodule->Key().getText()] withContent:[NSString stringWithUTF8String:(char *)swmodule->RenderText()]];
			}
			else
			{
				NSString *ref = [NSString stringWithUTF8String:swmodule->Key().getText()];
				[self createRef:ref withContent:@""];
			}
			
			lastIndex = (swmodule->Key()).Index();
			(*swmodule)++;
			if(lastIndex == (swmodule->Key()).Index())
				break;
		}while (element && swmodule->Key() <= vk);
	}
	
	if([labels count] == 0)
	{
		[self createWarning];
	}
}
	
- (void)createRef:(NSString*)ref withContent:(id)content
{
	static float		h = 5;
	NSRect				frameRect = [self frame];
	NSTextView			*theTextView;
	NSTextField			*theTextField;
	
	{
		
		theTextField = [[NSTextField alloc] initWithFrame:NSMakeRect(5,h,600,20)];
		
		[theTextField setEditable:NO];
		[theTextField setSelectable:NO];
		[theTextField setBezeled:NO];
		[theTextField setDrawsBackground:NO];
		[theTextField setStringValue:ref];
		
		[self addSubview:theTextField];
		[labels addObject:theTextField];
	}

	//h += 25;
	{
		
		theTextView = [[NSTextView alloc] initWithFrame:NSMakeRect(5,h,frameRect.size.width-20,20)];
		[theTextView setAllowsUndo:YES];
		[theTextView setVerticallyResizable:YES];
		[theTextView setHorizontallyResizable:NO];
		
		[[theTextView textContainer] setContainerSize:NSMakeSize(frameRect.size.width, FLT_MAX)];
		//[[theTextView textContainer] setWidthTracksTextView:YES];
		
		[theTextView setDelegate:self];
		
		[theTextView insertText:content];
		
		if([content length] == 0)
		{
			[theTextView setTypingAttributes:[NSDictionary dictionaryWithObject:normalFont forKey:NSFontAttributeName]];
		}
		
		[self addSubview:theTextView];
		[theTextView setAutoresizingMask:NSViewWidthSizable];
		[textViews addObject:theTextView];
	}
	
	//h += 10;
}

	
- (void)createWarning
{
	NSTextField *theTextField = [[NSTextField alloc] initWithFrame:NSMakeRect(5,5,400,400)];
	
	[theTextField setEditable:NO];
	[theTextField setSelectable:NO];
	[theTextField setBezeled:NO];
	[theTextField setDrawsBackground:NO];
	[theTextField setStringValue:@"To edit a module, first navigate to a bible reference."];
	
	[self addSubview:theTextField];
	[labels addObject:theTextField];

	NSTextView *theTextView = [[NSTextView alloc] initWithFrame:NSMakeRect(5,-100,0,0)];
	[textViews addObject:theTextView];
}

- (void)frameDidChange:(NSNotification *)aNotification
{
	static BOOL reframing = NO;
	
	if(reframing) return;
	reframing = YES;
	[self reframe];
	reframing = NO;
}

/*- (void)textDidChange:(NSNotification *)aNotification
{
	//[self reframe];
	[self write];
}*/

- (void)reframe
{
	int			i;
	float		h = 5;
	NSSize		f = [[self enclosingScrollView] contentSize];
	NSRect		r;
	static NSSize	lastSize;
	
	for(i=0;i<[textViews count];i++)
	{
		NSTextView		*theTextView = [textViews objectAtIndex:i];
		NSTextField		*theTextField = [labels objectAtIndex:i];
		
		[theTextField setFrameOrigin:NSMakePoint(10, h)];
		h += 25;
		[theTextView setFrameOrigin:NSMakePoint(10, h)];
		//r = [theTextView frame];
		//[theTextView setFrame:NSMakeRect(10, h, f.width-20, r.size.height)];
				
		h += [theTextView frame].size.height;
		h += 10;
	}
	
	if(lastSize.width != f.width || lastSize.height != h)
		[self setFrame:NSMakeRect(0, 0, f.width, h)];
	lastSize = NSMakeSize(f.width, h);
	
	[self setNeedsDisplay:YES];
}

- (void)drawRect:(NSRect)rect
{
	int			i;
	
	[[NSColor colorWithCalibratedRed:1 green:.95 blue:.8 alpha:1] set];
	NSRectFill(rect);
	//NSDrawWindowBackground(rect);
	//NSEraseRect(rect);
	
	for(i=0;i<[textViews count];i++)
	{
		NSTextView		*theTextView = [textViews objectAtIndex:i];
		NSTextField		*theTextField = [labels objectAtIndex:i];
		
		NSDrawLightBezel(NSInsetRect([theTextView frame], -1, -1), rect);
	}
}

- (BOOL)isFlipped
{
	return YES;
}

- (BOOL)isOpaque
{
	return YES;
}

@end
