#import "EditTextView.h"
#import "SwordServer.h"
#import "utils.h"

NSRange NSZeroRange = {0,0};

@implementation EditTextView

- (void)setURL:(NSURL*)url {
	SwordModule *mod = [[SwordManager defaultManager] moduleForURL:url];
	NSString *ref = [SwordServer referenceForURL:url];
	
	//erase
	[[self textStorage] deleteCharactersInRange:NSMakeRange(0, [[self textStorage] length])];
		
	sword::VerseKey	vk;
	sword::ListKey listkey = vk.ParseVerseList(toUTF8(ref), "gen1", true);
	
	[self setReferences:&listkey module:mod];
}

- (void)setReferences:(sword::ListKey*)listkey module:(SwordModule*)mod {
	int					i, c, lastIndex;
	sword::SWModule		*swmodule;
	BOOL startIndex = YES;
	
	module = mod;
	swmodule = [module swmodule];
	
	c = listkey->Count();
	for (i = 0; i < c; i++)
	{
		sword::VerseKey *element = My_SWDYNAMIC_CAST(VerseKey, listkey->GetElement(i));
		sword::VerseKey vk;
		
		// is it a chapter or book - not atomic
		if(element)
		{
			// start at lower bound
			swmodule->Key(element->LowerBound());
			// find the upper bound
			vk = element->UpperBound();
			vk.Headings();
		}
		else
		{
			// set it up
			swmodule->Key(*(listkey->GetElement(i)));
		}
		
		//NSDictionary *options = [NSDictionary dictionaryWithObjectsAndKeys:[NSNumber numberWithInt:1], @"UseWebKit", nil];
			
		// while not past the upper bound
		do
		{
			const char *ctext = swmodule->RenderText();
			
			
			NSString *index = [NSString stringWithFormat: @"%@:",
				[NSString stringWithUTF8String:swmodule->Key().getText()]];
		
			NSAttributedString *attrString = [[NSAttributedString alloc] initWithString:index attributes:
				[NSDictionary dictionaryWithObjectsAndKeys:[NSColor grayColor], NSForegroundColorAttributeName, nil]];
				
			startIndex = NO;
			/*NSData *data = [index dataUsingEncoding:NSUnicodeStringEncoding];
			NSMutableAttributedString *attrString = [[NSMutableAttributedString alloc] initWithHTML:data options:options documentAttributes:NULL];
			*/
			/*
			NSString *contents = [NSString stringWithFormat:
				@"<span style=\"font-family: Lucidia-Grande;font-size:13px;\">%@</span>",
				[NSString stringWithUTF8String:ctext]];
				
			data = [contents dataUsingEncoding:NSUnicodeStringEncoding];
			NSMutableAttributedString *attrContents = [[NSMutableAttributedString alloc] initWithHTML:data options:options documentAttributes:NULL];
			
			[attrContents removeAttribute:NSLinkAttributeName range:NSMakeRange(0,[attrContents length])];
			[attrContents removeAttribute:NSForegroundColorAttributeName range:NSMakeRange(0,[attrContents length])];
			[attrContents fixAttributesInRange:NSMakeRange(0,[attrContents length])];
			
	*/
			
			NSString *contents = [NSString stringWithFormat: @"%@\n",
				[NSString stringWithUTF8String:ctext]];
		
			NSMutableAttributedString *attrContents = [[NSMutableAttributedString alloc] initWithString:contents];
			[attrContents removeAttribute:NSLinkAttributeName range:NSMakeRange(0,[attrContents length])];
			[attrContents removeAttribute:NSForegroundColorAttributeName range:NSMakeRange(0,[attrContents length])];
			[attrContents fixAttributesInRange:NSMakeRange(0,[attrContents length])];
			
	
			[[self textStorage] appendAttributedString:attrString];
			[[self textStorage] appendAttributedString:attrContents];
			//[[self textStorage] appendAttributedString:[[NSMutableAttributedString alloc] initWithString:@"hello"]];
			
			lastIndex = (swmodule->Key()).Index();
			(*swmodule)++;
			if(lastIndex == (swmodule->Key()).Index())
				break;
		}while (element && swmodule->Key() <= vk);
	}
}

#pragma mark -

- (id)initWithFrame:(NSRect)r
{
	self = [super initWithFrame:r];
	
	oldSelectedCharRange = NSMakeRange(0,0);
	[self setAllowsUndo:YES];
	[self setDelegate:self];
	
	return self;
}

- (BOOL)rangeEditable:(NSRange)range
{
	int index = range.location;
	NSTextStorage   *textStore = [self textStorage];
	
	while(index <= range.location + range.length && index < [textStore length])
	{
		id attribute;
		NSRange	editRange;
		
		attribute = [textStore attribute:NSForegroundColorAttributeName atIndex:index effectiveRange:&editRange];// inRange:NSMakeRange(0,[textStore length])];

		if(attribute) return NO;
		
		index = editRange.location + editRange.length;
	}
	return YES;
}

- (NSRange)maxRangeEditableAt:(int)location
{
	NSTextStorage   *textStore = [self textStorage];
	
	{
		id attribute;
		NSRange	editRange;
		
		attribute = [textStore attribute:NSForegroundColorAttributeName atIndex:location longestEffectiveRange:&editRange inRange:NSMakeRange(0,[textStore length])];

		if(attribute) return NSZeroRange;
		
		return editRange;
	}
}

- (void)textViewDidChangeSelection:(NSNotification *)aNotification
{
	[self setSelectedTextAttributes:[NSDictionary dictionary]];
}

- (BOOL)textView:(NSTextView *)textView shouldChangeTextInRange:(NSRange)affectedCharRange replacementString:(NSString *)replacementString
{
    return [self rangeEditable:affectedCharRange];
}

- (NSRange)textView:(NSTextView *)aTextView willChangeSelectionFromCharacterRange:(NSRange)oldSelCharRange toCharacterRange:(NSRange)affectedCharRange
{
    NSRange range = [self selectionRangeForProposedRange:affectedCharRange fromCharacterRange:oldSelCharRange granularity:NSSelectByCharacter];
    return range;
}

- (NSRange)selectionRangeForProposedRange:(NSRange)affectedCharRange granularity:(NSSelectionGranularity)granularity
{
	return [self selectionRangeForProposedRange:affectedCharRange fromCharacterRange:oldSelectedCharRange granularity:granularity];
}

- (NSRange)selectionRangeForProposedRange:(NSRange)affectedCharRange fromCharacterRange:(NSRange)oldRange granularity:(NSSelectionGranularity)granularity
{
	affectedCharRange = [super selectionRangeForProposedRange:affectedCharRange granularity:granularity];
	
    if([self rangeEditable:affectedCharRange])
	{
		oldSelectedCharRange = affectedCharRange;
	}
	else
	{
		//need to expand selection to as close as possible to affectedCharRange
		oldSelectedCharRange = NSIntersectionRange(affectedCharRange, [self maxRangeEditableAt:oldSelectedCharRange.location]);
	}
	
	return oldSelectedCharRange;
}

@end
