/* EditTextView */

#import <Cocoa/Cocoa.h>
#import "SwordModule.h"

#ifdef __cplusplus
#include <swtext.h>
#include <versekey.h>
#include <listkey.h>
#endif

@interface EditTextView : NSTextView
{
	NSRange		oldSelectedCharRange;
	
	SwordModule				*module;
}

- (BOOL)rangeEditable:(NSRange)range;
- (NSRange)maxRangeEditableAt:(int)location;

- (BOOL)textView:(NSTextView *)textView shouldChangeTextInRange:(NSRange)affectedCharRange replacementString:(NSString *)replacementString;
- (NSRange)textView:(NSTextView *)aTextView willChangeSelectionFromCharacterRange:(NSRange)oldSelectedCharRange toCharacterRange:(NSRange)affectedCharRange;
- (NSRange)selectionRangeForProposedRange:(NSRange)affectedCharRange granularity:(NSSelectionGranularity)granularity;
- (NSRange)selectionRangeForProposedRange:(NSRange)affectedCharRange fromCharacterRange:(NSRange)oldRange granularity:(NSSelectionGranularity)granularity;

@end
