/*	BibleService.h - Handles the bible service

	$Id: BibleService.m,v 1.8 2006/02/02 00:18:23 willthimbleby Exp $
	
	Copyright 2002 Will Thimbleby (will@thimbleby.net)
	
	This program is free software; you can redistribute it and/or modify it under the terms of the
	GNU General Public License as published by the Free Software Foundation version 2.
	
	This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
	even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
	General Public License for more details. (http://www.gnu.org/licenses/gpl.html)
*/

#import "BibleService.h"
#import "AppDelegate.h"
#import "SwordServer.h"
#import "NSString_Extensions.h"
#import "SwordModule.h"

@implementation BibleService

- (void)lookup:(NSPasteboard *)pboard userData:(NSString *)data error:(NSString **)error
{
	NSArray		*types;
	NSString	*pboardString, *result;
	NSString	*bibleName, *ref;
	NSURL		*url;
	
	// get the service bible name
	bibleName = [[NSUserDefaults standardUserDefaults] objectForKey:@"serviceBible"];
	
	// make sure pastboard contains a string
	types = [pboard types];
	if (![types containsObject:NSStringPboardType] || !(pboardString = [pboard stringForType:NSStringPboardType]))
	{
		*error = NSLocalizedString(@"Error: Pasteboard doesn't contain a string.", @"Pasteboard couldn't give string.");
		return;
	}
	
	// make sure that manager has been loaded since this gets called before the app delegate loads
	[[NSApp delegate] loadManager];
	
	pboardString = [pboardString addPercentEscapes];
	url = [NSURL URLWithString:[NSString stringWithFormat:@"sword://%@/", bibleName]];
	url = [NSURL URLWithString:pboardString relativeToURL:url];
	
	result = [SwordServer generateTextForURL:url];
	
	SwordModule *module = [[SwordManager defaultManager] moduleForURL:url];
	
	ref = [SwordServer referenceForURL:url];
	ref = [module fullRefName:ref];
	
	result = [NSString stringWithFormat:@"%@\n(%@ %@)", result, ref, [module moduleName]];
	
	// if there was no text returned then there was an error
	if (!result)
	{
		*error = NSLocalizedString(@"Error: Couldn't create reference %@.", @"Couldn't perform service operation.");
		return;
	}
	
	// We now return the looked up data... 
	types = [NSArray arrayWithObjects:NSHTMLPboardType, NSStringPboardType,nil];
	[pboard declareTypes:types owner:nil];
	[pboard setString:result forType:NSStringPboardType];
	//[pboard setData:html forType:NSHTMLPboardType];
	
	return;
}
@end
