/*
 IMPORTANT:  This Apple software is supplied to you by Apple Computer, Inc. ("Apple") in
 consideration of your agreement to the following terms, and your use, installation, 
 modification or redistribution of this Apple software constitutes acceptance of these 
 terms.  If you do not agree with these terms, please do not use, install, modify or 
 redistribute this Apple software.
 
 In consideration of your agreement to abide by the following terms, and subject to these 
 terms, Apple grants you a personal, non-exclusive license, under Apples copyrights in 
 this original Apple software (the "Apple Software"), to use, reproduce, modify and 
 redistribute the Apple Software, with or without modifications, in source and/or binary 
 forms; provided that if you redistribute the Apple Software in its entirety and without 
 modifications, you must retain this notice and the following text and disclaimers in all 
 such redistributions of the Apple Software.  Neither the name, trademarks, service marks 
 or logos of Apple Computer, Inc. may be used to endorse or promote products derived from 
 the Apple Software without specific prior written permission from Apple. Except as expressly
 stated in this notice, no other rights or licenses, express or implied, are granted by Apple
 herein, including but not limited to any patent rights that may be infringed by your 
 derivative works or by other works in which the Apple Software may be incorporated.
 
 The Apple Software is provided by Apple on an "AS IS" basis.  APPLE MAKES NO WARRANTIES, 
 EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF NON-INFRINGEMENT, 
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, REGARDING THE APPLE SOFTWARE OR ITS 
 USE AND OPERATION ALONE OR IN COMBINATION WITH YOUR PRODUCTS.
 
 IN NO EVENT SHALL APPLE BE LIABLE FOR ANY SPECIAL, INDIRECT, INCIDENTAL OR CONSEQUENTIAL 
 DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS 
 OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) ARISING IN ANY WAY OUT OF THE USE, 
 REPRODUCTION, MODIFICATION AND/OR DISTRIBUTION OF THE APPLE SOFTWARE, HOWEVER CAUSED AND 
 WHETHER UNDER THEORY OF CONTRACT, TORT (INCLUDING NEGLIGENCE), STRICT LIABILITY OR 
 OTHERWISE, EVEN IF APPLE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/*
    DataProtocol.m
    Copyright 2003, Apple, Inc. All rights reserved.
*/
#import "SwordURLProtocol.h"
#import "SwordServer.h"
#import "NSString_Extensions.h"
#import "SwordBible.h"

#import <Foundation/Foundation.h>
#import <Foundation/NSError.h>

NSString *SwordScheme = @"sword";

// Implement the required methods for the concrete subclass of WebProtocolHandler
// that will handle our custom protocol.
@implementation SwordURLProtocol

+ (void)setup
{
    [NSURLProtocol registerClass:[SwordURLProtocol class]];
}


+ (BOOL)canInitWithRequest:(NSURLRequest *)theRequest
{
    return ([[[theRequest URL] scheme] caseInsensitiveCompare: SwordScheme] == NSOrderedSame);
}

+(NSURLRequest *)canonicalRequestForRequest:(NSURLRequest *)request
{
	//return request;

	NSURL   *aURL;
	
{
	aURL = [request URL];
	
	if([aURL fragment])
	{
		NSString	*ref = [[aURL fragment] removePercentEscapes];
		
		ref = [SwordBible firstRefName:ref];
		ref = [[NSString stringWithFormat:@"#%@", ref] addPercentEscapes];
		
		aURL = [NSURL URLWithString:ref relativeToURL:aURL];
	}
	else
		return request;
}

    return [NSURLRequest requestWithURL:aURL];
}
/*-(id)initWithRequest:(NSURLRequest *)request cachedResponse:(NSCachedURLResponse *)cachedResponse client:(id <NSURLProtocolClient>)client
{
	NSLog(@"initURL:%@ %@ %@",request,cachedResponse,client);
	return [super initWithRequest:request cachedResponse:cachedResponse client:client];
}*/

- (BOOL)recieveData:(NSData *)data
{
	if(continueLoading)
		[[self client] URLProtocol:self didLoadData:data];
	
	return continueLoading;
}

- (void)startLoading
{
    id<NSURLProtocolClient> client = [self client];
    NSURLRequest *request = [self request];
    NSData *data;
	
	NSLog(@"start loading %@", request);
	continueLoading = YES;

   // data = [SwordServer generateDataForRequest:request];
   // if (data)
	{
        NSURLResponse *response = [[NSURLResponse alloc] initWithURL:[request URL] MIMEType:@"text/html" expectedContentLength:-1 textEncodingName:@"utf-8"];
        [client URLProtocol:self didReceiveResponse:response cacheStoragePolicy:NSURLCacheStorageNotAllowed];
        //[client URLProtocol:self didLoadData:data];
		//[SwordServer generateDataForRequest:request protocol:self];
				//[SwordServer generateDataForRequest:request protocol:self];
				[NSThread detachNewThreadSelector:@selector(startThread:) toTarget:self withObject:request];
        //[response release]; <- in apple's code but crashes
    }
	/*else
	{
        int resultCode;

        resultCode = NSURLErrorResourceUnavailable;

        [client URLProtocol:self didFailWithError:[NSError errorWithDomain:NSURLErrorDomain code:resultCode userInfo:nil]];
    }*/
	//NSLog(@"end loading %@", request);
}

- (void)startThread:(NSURLRequest*)request
{
	NSAutoreleasePool *arp = [[NSAutoreleasePool alloc] init];
	
	[SwordServer generateDataForRequest:request protocol:self];
	[[self client] URLProtocolDidFinishLoading:self];
	NSLog(@"end loading");
	
	[arp release];
}

- (void)stopLoading
{
	NSLog(@"stop loading");
	continueLoading = NO;
}

@end

