//
//  SwordServer.m
//  MacSword
//
//  Created by Will Thimbleby on Sat Jan 10 2004.
//  Copyright (c) 2004 Will Thimbleby. All rights reserved.
//  Altered by Manfred Bergmann
//

#import <CocoLogger/CocoLogger.h>
#import "SwordServer.h"
#import "NSString_Extensions.h"
#import "NSArray_Extensions.h"
#import "AGRegex/AGRegex.h"
#import "SwordURLProtocol.h"
#import "SwordModule.h"

extern BOOL apperanceChanged;

NSLock  *serverLock = 0;

@implementation SwordServer

+ (NSString *)referenceForURL:(NSURL *)aUrl {
	NSString *reference;
	
	if([aUrl path] && [[aUrl path] length] > 0) {
		reference = [[aUrl path] substringFromIndex:1];
	} else {
		reference = @"";
	}

	if([reference isEqualToString:@"/"]) {
		reference = @"";
	}

	if([aUrl parameterString]) {
		reference = [reference stringByAppendingFormat:@";%@", [[aUrl parameterString] removePercentEscapes]];
	}
	
	reference = [reference removePercentEscapes];
	
	unichar mdashchars[1] = {0x2013};
	NSString *mdash = [NSString stringWithCharacters:mdashchars length:1];
	
	AGRegex *regex = [[AGRegex alloc] initWithPattern:mdash options:AGRegexCaseInsensitive];
	reference = [regex replaceWithString:@"-" inString:reference];
	[regex release];
	
	return reference;
}

+ (NSString *)generateTextForURL:(NSURL *)aUrl {
	SwordModule *module;
	NSString *textString;
	NSString *reference;
	
	if(!serverLock) {
		serverLock = [[NSLock alloc] init];
	}
	[serverLock lock];
    
	reference = [SwordServer referenceForURL:aUrl];
	module = [[SwordManager defaultManager] moduleForURL:aUrl];
	textString = [module htmlForRef:reference embelish:NO];
	
	[serverLock unlock];
	
    NSData *textData = [textString dataUsingEncoding: NSUnicodeStringEncoding];
    NSAttributedString *attrString = [[NSMutableAttributedString alloc] initWithHTML:textData documentAttributes:NULL];
	return [[attrString autorelease] string];
}

+ (NSData *)generateDataForRequest:(NSURLRequest *)request {
	return [SwordServer generateDataForURL:[[request URL] standardizedURL]];
}

+ (void)generateDataForRequest:(NSURLRequest *)request protocol:(SwordURLProtocol*)protocol {
	[SwordServer generateDataForURL:[[request URL] standardizedURL] protocol:protocol];
}

/** the header string */
NSString *headerString = NULL;

+ (void)generateDataForURL:(NSURL *)aUrl protocol:(SwordURLProtocol *)protocol {
	NSArray				*modules;
	SwordModule			*module;
	NSString			*HTMLString;
	NSString			*reference;
	NSMutableDictionary	*parameters;
	static int			cacheCSSNum = 0;
	
	if([[aUrl host] hasPrefix:@"css-"]) {
		[SwordServer generateCSSForURL:aUrl protocol:protocol];
	}
		
	if(!serverLock) serverLock = [[NSLock alloc] init];
	[serverLock lock];
	
	modules = [[aUrl host] componentsSeparatedByString:@"."];
	
	reference = [SwordServer referenceForURL:aUrl];
	NSLog(@"Fragment:  %@", [aUrl fragment]); 
	
	module = [[SwordManager defaultManager] moduleForURL:aUrl];

	// Options
    NSEnumerator *aEnum;
    NSString *option;
    aEnum = [[module displayOptions] keyEnumerator];    
    while((option = [aEnum nextObject])) {
        [[SwordManager defaultManager] setGlobalOption:option value:@"On"];
    }
	
	// Parameters
	parameters = [NSMutableDictionary dictionary];
	if([aUrl query]) {
		NSArray *pArray = [[[aUrl query] removePercentEscapes] componentsSeparatedByString:@"&"];
		
		NSEnumerator		*aEnum;
		NSString			*param;
		NSArray				*pBits;
		
		aEnum = [pArray objectEnumerator];
		
		while((param = [aEnum nextObject])) {
			pBits = [param componentsSeparatedByString:@"="];
			if([pBits count] > 1) {
                // only parameters with '=' are allowed
				[parameters setObject:[pBits objectAtIndex:1] forKey:[pBits objectAtIndex:0]];
			}
		}
	}
	
	//fragment
	if([aUrl fragment]) {
		if([parameters objectForKey:@"highlight"]) {
			[parameters setObject:[NSString stringWithFormat:@"%@;%@",[[aUrl fragment] removePercentEscapes],[parameters objectForKey:@"highlight"]] forKey:@"highlight"];
		} else {
			[parameters setObject:[[aUrl fragment] removePercentEscapes] forKey:@"highlight"];
		}
	}
	
	if(!headerString) {
		headerString = [[NSString stringWithContentsOfFile: [[NSBundle mainBundle] pathForResource:@"entry_template" ofType:@"html"]] retain];
	}
			
	if([modules count] > 1) {
		NSString *modName;
		
		NSMutableArray *myModules = [NSMutableArray array];
		NSEnumerator *aEnum = [modules objectEnumerator];
		
		while((modName = [aEnum nextObject])) {
			[myModules addObject:[[SwordManager defaultManager] moduleWithName:modName]];
		}
		
		if([reference length] == 0 || [reference compare:aboutEntrySpecifier options:NSCaseInsensitiveSearch range:NSMakeRange(0,[aboutEntrySpecifier length])] == NSOrderedSame) {
			HTMLString = [[myModules collectWithSelector:@selector(htmlForDescription) withObject:NULL] componentsJoinedByString:@"<BR><BR>"];
			[protocol recieveData:[HTMLString dataUsingEncoding: NSUTF8StringEncoding]];
		} else {
			NSString		*css;
			int				cssSheet;
			cssSheet = [[[NSUserDefaults standardUserDefaults] objectForKey:@"style-sheet selected"] intValue];
			
			if(cssSheet > 1)  {
				css = [NSString stringWithFormat:@"file://%@", [[[NSUserDefaults standardUserDefaults] objectForKey:@"style-sheets"] objectAtIndex:cssSheet-2]];
			} else {
				if([aUrl query]) {
					css = [NSString stringWithFormat:@"sword://css-%@/%d?%@", [module moduleName], cacheCSSNum, [aUrl query]];
				} else {
					css = [NSString stringWithFormat:@"sword://css-%@/%d", [module moduleName], cacheCSSNum];
				}
			}
						
			//header
			HTMLString = [NSString stringWithFormat:headerString, css];
			[protocol recieveData:[HTMLString dataUsingEncoding:NSUTF8StringEncoding]];
			
			[SwordBible parallel:myModules htmlForRef:reference embelish:YES highlight:NO highlightReference:[parameters objectForKey:@"highlight"] protocol:protocol];
		}
	} else {
		if(apperanceChanged) {
			apperanceChanged=NO;
			cacheCSSNum++;
		}
		if([module isLocked] || [reference length] == 0 || [reference compare:aboutEntrySpecifier options:NSCaseInsensitiveSearch range:NSMakeRange(0,[aboutEntrySpecifier length])] == NSOrderedSame) {
			HTMLString = [module htmlForDescription];
			[protocol recieveData:[HTMLString dataUsingEncoding:NSUTF8StringEncoding]];
		} else {
			NSString		*css;
			int				cssSheet;
			
			cssSheet = [[[NSUserDefaults standardUserDefaults] objectForKey:@"style-sheet selected"] intValue];
			
			if(cssSheet > 1) 
				css = [NSString stringWithFormat:@"file://%@", [[[NSUserDefaults standardUserDefaults] objectForKey:@"style-sheets"] objectAtIndex:cssSheet-2]];
			else {
				if([aUrl query])
					css = [NSString stringWithFormat:@"sword://css-%@/%d?%@", [module moduleName], cacheCSSNum, [aUrl query]];
				else
					css = [NSString stringWithFormat:@"sword://css-%@/%d", [module moduleName], cacheCSSNum];
			}
			
			//header
			HTMLString = [NSString stringWithFormat:headerString, css];
			[protocol recieveData:[HTMLString dataUsingEncoding: NSUTF8StringEncoding]];
			
            HTMLString = [module htmlForRef:reference highlightReference:[parameters objectForKey:@"highlight"] protocol:protocol];
		}
	}
	
	// Options
    aEnum = [[module displayOptions] keyEnumerator];    
    while((option = [aEnum nextObject])) {
        [[SwordManager defaultManager] setGlobalOption:option value:@"Off"];
    }
	
	[serverLock unlock];
			
}

+ (NSData *)generateDataForURL:(NSURL *)aUrl {
	NSArray				*modules;
	SwordModule			*module;
	NSString			*HTMLString;
	NSString			*reference;
	NSMutableDictionary	*parameters;
	static int			cacheCSSNum = 0;
	
	if([[aUrl host] hasPrefix:@"css-"]) {
		return [SwordServer generateCSSForURL:aUrl];
	}

	if(!serverLock) serverLock = [[NSLock alloc] init];
	[serverLock lock];
	
	modules = [[aUrl host] componentsSeparatedByString:@"."];
	
	reference = [SwordServer referenceForURL:aUrl];
	NSLog(@"Fragment:  %@", [aUrl fragment]); 
	
	module = [[SwordManager defaultManager] moduleForURL:aUrl];

    // Options
    NSEnumerator		*aEnum;
    NSString			*option;        
    aEnum = [[module displayOptions] keyEnumerator];    
    while((option = [aEnum nextObject])) {
        [[SwordManager defaultManager] setGlobalOption:option value:@"On"];
    }
	
    // Parameters
	parameters = [NSMutableDictionary dictionary];
	if([aUrl query]) {
		NSArray *pArray = [[[aUrl query] removePercentEscapes] componentsSeparatedByString:@"&"];
		
        NSEnumerator		*aEnum;
        NSString			*param;
        NSArray				*pBits;
        
        aEnum = [pArray objectEnumerator];
        
        while((param = [aEnum nextObject])) {
            pBits = [param componentsSeparatedByString:@"="];
            if([pBits count] > 1) {
                [parameters setObject:[pBits objectAtIndex:1] forKey:[pBits objectAtIndex:0]];
            }
		}
	}
	
	//fragment
	if([aUrl fragment]) {
		if([parameters objectForKey:@"highlight"])
			[parameters setObject:[NSString stringWithFormat:@"%@;%@",[[aUrl fragment] removePercentEscapes],[parameters objectForKey:@"highlight"]] forKey:@"highlight"];
		else
			[parameters setObject:[[aUrl fragment] removePercentEscapes] forKey:@"highlight"];
	}
	
	if([modules count] > 1) {
		NSString *modName;
		
		NSMutableArray *myModules = [NSMutableArray array];
		NSEnumerator *aEnum = [modules objectEnumerator];
		
		while((modName = [aEnum nextObject])) {
			[myModules addObject:[[SwordManager defaultManager] moduleWithName:modName]];
		}
		
		NSLog(@"%@", myModules);
		
		if([reference length] == 0 || [reference compare:aboutEntrySpecifier options:NSCaseInsensitiveSearch range:NSMakeRange(0,[aboutEntrySpecifier length])] == NSOrderedSame) {
			HTMLString = [[myModules collectWithSelector:@selector(htmlForDescription) withObject:NULL] componentsJoinedByString:@"<BR><BR>"];
		} else {
			NSString *css;
			int	cssSheet;
			
			cssSheet = [[[NSUserDefaults standardUserDefaults] objectForKey:@"style-sheet selected"] intValue];
			
			if(cssSheet > 1) 
				css = [NSString stringWithFormat:@"file://%@", [[[NSUserDefaults standardUserDefaults] objectForKey:@"style-sheets"] objectAtIndex:cssSheet-2]];
			else {
				if([aUrl query])
					css = [NSString stringWithFormat:@"sword://css-%@/%d?%@", [module moduleName], cacheCSSNum, [aUrl query]];
				else
					css = [NSString stringWithFormat:@"sword://css-%@/%d", [module moduleName], cacheCSSNum];
			}
			
			//+ (NSString *)parallel:(NSArray*)swordmodules htmlForRef:(NSString *)reference embelish:(BOOL)embelish highlight:(BOOL)highlight highlightReference:(NSString*)highlightRef
			HTMLString = [SwordBible parallel:myModules htmlForRef:reference embelish:YES highlight:NO highlightReference:[parameters objectForKey:@"highlight"]];
			
			/*HTMLString = [NSString stringWithFormat:
				[NSString stringWithContentsOfFile: [[NSBundle mainBundle] pathForResource:@"entry_template" ofType:@"html"]],
				css,
				HTMLString];*/
		}
	} else {
		if(apperanceChanged) {
			apperanceChanged=NO;
			cacheCSSNum++;
		}
		if([reference length] == 0 || [reference compare:aboutEntrySpecifier options:NSCaseInsensitiveSearch range:NSMakeRange(0,[aboutEntrySpecifier length])] == NSOrderedSame) {
			HTMLString = [module htmlForDescription];
		} else {
			NSString		*css;
			int				cssSheet;
			
			cssSheet = [[[NSUserDefaults standardUserDefaults] objectForKey:@"style-sheet selected"] intValue];
			
			if(cssSheet > 1) 
				css = [NSString stringWithFormat:@"file://%@", [[[NSUserDefaults standardUserDefaults] objectForKey:@"style-sheets"] objectAtIndex:cssSheet-2]];
			else {
				if([aUrl query])
					css = [NSString stringWithFormat:@"sword://css-%@/%d?%@", [module moduleName], cacheCSSNum, [aUrl query]];
				else
					css = [NSString stringWithFormat:@"sword://css-%@/%d", [module moduleName], cacheCSSNum];
			}
			
			if([parameters objectForKey:@"highlight"]) {
				HTMLString = [module htmlForRef:reference highlightReference:[parameters objectForKey:@"highlight"]];
			} else {
				HTMLString = [module htmlForRef:reference];
            }			
		}
	}
	
	// Options
    aEnum = [[module displayOptions] keyEnumerator];    
    while((option = [aEnum nextObject])) {
        [[SwordManager defaultManager] setGlobalOption:option value:@"Off"];
    }
	
	[serverLock unlock];
	
	return [HTMLString dataUsingEncoding: NSUTF8StringEncoding];
}

NSString *cssFile = NULL;

+ (void)generateCSSForURL:(NSURL *)aUrl protocol:(SwordURLProtocol *)protocol {
	NSString *HTMLString;
	NSDictionary *options;
	SwordModule	*module;
	BOOL RtoL = NO;
	
	if(!cssFile) {
		cssFile = [[NSString stringWithContentsOfFile: [[NSBundle mainBundle] pathForResource:@"css_template" ofType:@"css"]] retain];
	}
	
	module = [[SwordManager defaultManager] moduleForURL:aUrl];
	
	if([[aUrl host] rangeOfString:@"."].location == NSNotFound && [module getConfigEntry:@"Direction"] && [[module getConfigEntry:@"Direction"] isEqualToString:@"RtoL"]) {
		RtoL = YES;
	}
	
    MBLOGV(MBLOG_DEBUG, @"generate CSS, have utl: %@\n", [aUrl description]);
    options = [module displayOptions];
	
	HTMLString = [NSString stringWithFormat: cssFile,
		[[NSUserDefaults standardUserDefaults] objectForKey:@"style-font family"],
		[[NSUserDefaults standardUserDefaults] objectForKey:@"style-font size"],
		[[NSUserDefaults standardUserDefaults] boolForKey:@"inset text"] ? 40 : 10,
		[[NSUserDefaults standardUserDefaults] objectForKey:@"style-text color"],
		[[NSUserDefaults standardUserDefaults] objectForKey:@"style-background color"],
		[[NSUserDefaults standardUserDefaults] objectForKey:@"style-heading color"],
		[[NSUserDefaults standardUserDefaults] objectForKey:@"style-heading color"],
		"height:100%;",//text-align:right;",//[options containsObject:@"Verses On One Line"] ? " padding-right:1mm; display:table-cell; text-align:right; width:1.2em" : "",
		[options objectForKey:@"No Verse Numbering"] ? "display:none;" : "",
		[options objectForKey:@"Verses On One Line"] ? "block" : "inline",
		RtoL ? "direction:rtl; text-align:right;" : "",
		[[NSUserDefaults standardUserDefaults] objectForKey:@"style-xref color"],
		[[NSUserDefaults standardUserDefaults] objectForKey:@"style-morph color"],
		[[NSUserDefaults standardUserDefaults] objectForKey:@"style-strongs color"],
		[[NSUserDefaults standardUserDefaults] objectForKey:@"style-footnote color"],
		[[NSUserDefaults standardUserDefaults] objectForKey:@"style-footnote color"],
		[[NSUserDefaults standardUserDefaults] objectForKey:@"style-jesus color"]];
		
	[protocol recieveData:[HTMLString dataUsingEncoding: NSUTF8StringEncoding]];
}

+ (NSData *)generateCSSForURL:(NSURL *)aUrl {
	NSString *HTMLString;
	NSDictionary *options;
	SwordModule	*module;
	BOOL RtoL = NO;
	
	module = [[SwordManager defaultManager] moduleForURL:aUrl];
	
	if([module getConfigEntry:@"Direction"] && [[module getConfigEntry:@"Direction"] isEqualToString:@"RtoL"]) {
		RtoL = YES;
	}
	
    options = [module displayOptions];
	
	HTMLString = [NSString stringWithFormat:
		[NSString stringWithContentsOfFile: [[NSBundle mainBundle] pathForResource:@"css_template" ofType:@"css"]],
		[[NSUserDefaults standardUserDefaults] objectForKey:@"style-font family"],
		[[NSUserDefaults standardUserDefaults] objectForKey:@"style-font size"],
		[[NSUserDefaults standardUserDefaults] boolForKey:@"inset text"] ? 40 : 10,
		[[NSUserDefaults standardUserDefaults] objectForKey:@"style-text color"],
		[[NSUserDefaults standardUserDefaults] objectForKey:@"style-background color"],
		[[NSUserDefaults standardUserDefaults] objectForKey:@"style-heading color"],
		[[NSUserDefaults standardUserDefaults] objectForKey:@"style-heading color"],
		"height:100%;",//text-align:right;",//[options containsObject:@"Verses On One Line"] ? " padding-right:1mm; display:table-cell; text-align:right; width:1.2em" : "",
		[options objectForKey:@"No Verse Numbering"] ? "display:none;" : "",
		[options objectForKey:@"Verses On One Line"] ? "block" : "inline",
		RtoL ? "direction:rtl; text-align:right;" : "",
		[[NSUserDefaults standardUserDefaults] objectForKey:@"style-xref color"],
		[[NSUserDefaults standardUserDefaults] objectForKey:@"style-morph color"],
		[[NSUserDefaults standardUserDefaults] objectForKey:@"style-strongs color"],
		[[NSUserDefaults standardUserDefaults] objectForKey:@"style-footnote color"],
		[[NSUserDefaults standardUserDefaults] objectForKey:@"style-footnote color"],
		[[NSUserDefaults standardUserDefaults] objectForKey:@"style-jesus color"]];
		
	return [HTMLString dataUsingEncoding: NSUTF8StringEncoding];
}

@end
