//
//  SwordServer.h
//  MacSword
//
//  Created by Will Thimbleby on Sat Jan 10 2004.
//  Copyright (c) 2004 Will Thimbleby. All rights reserved.
//  Altered by Manfred Bergmann
//

#import <Foundation/Foundation.h>
#import "SwordManager.h"

@class SwordURLProtocol;

@interface SwordServer : NSObject 
{
}

+ (NSString *)generateTextForURL:(NSURL *)aUrl;
+ (NSData *)generateDataForURL:(NSURL *)aUrl;
+ (NSData *)generateCSSForURL:(NSURL*)aUrl;
+ (NSData *)generateDataForRequest:(NSURLRequest *)request;
+ (void)generateDataForRequest:(NSURLRequest *)request protocol:(SwordURLProtocol*)protocol;
+ (void)generateDataForURL:(NSURL *)aUrl protocol:(SwordURLProtocol*)protocol;
+ (void)generateCSSForURL:(NSURL*)aUrl protocol:(SwordURLProtocol*)protocol;
+ (NSString *)referenceForURL:(NSURL *)aUrl;

@end
