//
//  SwordSearching.h
//  MacSword
//
//  Created by William Thimbleby on Thu Mar 10 2005.
//  Copyright (c) 2005 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "SwordModule.h"
#import "SwordBible.h"
#import "SwordDictionary.h"
#import "SwordBook.h"

#ifdef __cplusplus
#include <swtext.h>
#include <versekey.h>
#endif

@class Indexer;

@interface SwordModule(Searching)

- (void)callback:(char) percent;
- (BOOL)hasIndex;
- (void)createIndex:(NSProgressIndicator*)indexProgress;
- (void)stopSearch;
- (void)stopIndex;
- (void)searchFor:(NSString*)search 
			scope:(NSString*)scope 
		   method:(int)method 
	   ignoreCase:(BOOL)ignore 
		   object:(id)sobject 
		 selector:(SEL)selector 
		  results:(NSMutableArray*)results;

//- (LuceneHits *)indexSearchFor:(NSString*)search scope:(NSString *)scope;

// indexing stuff
//- (id)indexContents:(sword::TreeKeyIdx *)treeKey intoIndex:(LuceneIndexWriter *)writer;

//- (void)indexContentsIntoIndex:(Indexer *)indexer withProgress:(NSProgressIndicator*)indexProgress;


@end

@interface SwordBible(Searching)

- (void)indexContentsIntoIndex:(Indexer *)indexer withProgress:(NSProgressIndicator*)indexProgress;

@end

@interface SwordDictionary(Searching)

- (void)indexContentsIntoIndex:(Indexer *)indexer withProgress:(NSProgressIndicator*)indexProgress;

@end

@interface SwordBook(Searching)

- (void)indexContentsIntoIndex:(Indexer *)indexer withProgress:(NSProgressIndicator*)indexProgress;

@end