/*	SwordModule.h - Sword API wrapper for Modules.

	Copyright 2003 Will Thimbleby (wjt100@york.ac.uk)
	Based on code by Nathan Youngman (http://www.nathany.com)

	This program is free software; you can redistribute it and/or modify it under the terms of the
	GNU General Public License as published by the Free Software Foundation version 2.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
	even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
	General Public License for more details. (http://www.gnu.org/licenses/gpl.html)
*/

//#import <Foundation/Foundation.h>
#import <Cocoa/Cocoa.h>		// need Cocoa for attributed string extensions
#import <CocoLogger/CocoLogger.h>

#ifdef __cplusplus
#include <swtext.h>
#include <versekey.h>

#include <regex.h>

class sword::SWModule;
#endif

#define My_SWDYNAMIC_CAST(className, object) (sword::className *)((object)?((object->getClass()->isAssignableFrom(#className))?object:0):0)

extern NSString *aboutEntrySpecifier;

@class SwordManager, SwordURLProtocol;

typedef enum
{
	bible, 
    dictionary, 
    commentary, 
    book, 
    devotional
}ModuleType;

@interface SwordModule : NSObject {
	NSString *moduleName;
	SwordManager *myManager;
	ModuleType type;
    NSString *typeString;
	
    /** the status of the module */
    int status;

#ifdef __cplusplus
	sword::SWModule	*module;
#endif

	id searchCallback;
	SEL searchSelector;
	
	//LuceneIndexSearcher* luceneSearcher;
	BOOL terminateSearch, terminateIndex;
	
	NSLock *moduleLock;
    
    NSMutableDictionary *displayOptions;
}

/**
\brief maps type string to ModuleType enum
 @param[in] typeStr type String as in -moduleType(SwordModule)
 @return type according to ModuleType enum
 */
+ (ModuleType)moduleTypeForModuleTypeString:(NSString *)typeStr;

+ (NSDictionary *)defaultDisplayOptions;

// Module
- (id)initWithSwordManager: (SwordManager *)manager moduleName:(NSString*)name;
#ifdef __cplusplus
- (id)initWithSWModule:(sword::SWModule *)aModule;
#endif
- (void)dealloc;

- (NSString *)getConfigEntry:(NSString*)config;
- (BOOL)isUnicode;
- (BOOL)isEncrypted;
- (NSString *)moduleDescription;
- (NSString *)versionNumber;
- (NSString *)aboutString;
- (ModuleType)type;
- (NSString *)moduleType;
- (NSString *)moduleName;
- (NSString *)name;
- (NSString *)typeString;
- (void)setTypeString:(NSString *)value;
- (int)status;
- (void)setStatus:(int)value;
- (NSDictionary *)displayOptions;
- (void)setDisplayOptions:(NSDictionary *)value;
#ifdef __cplusplus
- (sword::SWModule *)swmodule;
#endif
- (BOOL) hasFeature:(NSString *)feature;

- (BOOL)unlock:(NSString *)unlockKey;
- (BOOL)isLocked;
- (BOOL)isEncrypted;

/** numnber of entries
 abstract method, should be overriden by subclasses
 */
- (long)entryCount;

- (NSString *)htmlForDescription;
- (NSString *)entryForRef:(NSString *)reference;
- (NSString *)htmlForRef:(NSString *)reference;
- (NSString *)htmlForRef:(NSString *)reference highlightReference:(NSString *)hr;
- (NSString *)htmlForRef:(NSString *)reference embelish:(BOOL)embelish;
- (NSString *)htmlForRef:(NSString *)reference embelish:(BOOL)embelish protocol:(SwordURLProtocol *)protocol;
//- (void)htmlForRef:(NSString *)reference embelish:(BOOL)embelish protocol:(SwordURLProtocol *)protocol;

- (void)writeEntry:(NSString *)value forRef:(NSString*)reference;

@end
