/*	SwordManager.h - Sword API wrapper for Modules.

	Copyright 2003 Will Thimbleby (wjt100@york.ac.uk)
	Based on code by Nathan Youngman (http://www.nathany.com)

	This program is free software; you can redistribute it and/or modify it under the terms of the
	GNU General Public License as published by the Free Software Foundation version 2.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
	even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
	General Public License for more details. (http://www.gnu.org/licenses/gpl.html)
*/

#import <Foundation/Foundation.h>

@class SwordModule, SwordBook, SwordBible, SwordDictionary, SwordCommentary;

#ifdef __cplusplus
#include <swmgr.h>		// C++ Sword API
#include <localemgr.h>
//#include "SWMgr2.h"
#include <markupfiltmgr.h>

// Filters
#include <markupfiltmgr.h>
#include <osishtmlhref.h>
#include <thmlhtmlhref.h>
#include <gbfhtmlhref.h>
#include <teihtmlhref.h>
#include <plainhtml.h>

//class /*sword::*/SWMgr2;
class sword::SWModule;
#endif

#define SWMODTYPE_BIBLE			@"Biblical Texts"
#define SWMODTYPE_COMMENTARY	@"Commentaries"

@interface SwordManager : NSObject {
    
#ifdef __cplusplus
	sword::SWMgr *manager;
	sword::SWFilter *plainFilter, *thmlFilter, *gbfFilter, *osisFilter, *teiFilter;
	sword::SWFilter *thmlStripFilter, *gbfStripFilter, *osisStripFilter, *teiStripFilter;
#endif

	NSMutableDictionary	*modules;
	NSMutableDictionary *moduleData;
	NSMutableDictionary *moduleTypes;

    NSString *modulePath;
	NSLock  *managerLock;
    BOOL temporaryManager;
}

// ------------------- getter / setter -------------------
- (NSDictionary *)modules;
- (void)setModules:(NSDictionary *)value;

- (NSDictionary *)moduleData;
- (void)setModuleData:(NSDictionary *)value;

- (NSDictionary *)moduleTypes;
- (void)setModuleTypes:(NSDictionary *)value;

- (NSString *)modulePath;
- (void)setModulePath:(NSString *)value;

- (BOOL)temporaryManager;
- (void)setTemporaryManager:(BOOL)value;

// --------------------- methods -----------------------

/*" Constructor "*/
- (id)initWithPath:(NSString *)path;
- (void)addPath:(NSString*)path;
- (void)dealloc;

+ (void)initManagersWithPath:(NSString*)path;
+ (SwordManager *)defaultManager;

/** reinit the manager */
- (void)reInit;

- (void)addRenderFilters;
- (void)refreshModuleData;

- (void)setCipherKey:(NSString*)key forModuleNamed:(NSString*)name;

- (void)setGlobalOption:(NSString*)option value:(NSString*)value;

- (NSString *)descriptionForModuleName:(NSString *)name;
- (NSString *)typeForModuleName:(NSString *)name;
- (NSString *)languageAbbrevForModuleName:(NSString *)name;
- (NSString *)versionForModuleName:(NSString *)name;
- (id)featureForModuleName:(NSString *)name feature:(NSString *)feature;

- (NSArray *)listModules;
- (NSEnumerator *)moduleNameEnumerator;
- (NSArray *)allModuleNames;
- (SwordModule *)moduleWithName:(NSString*)name;
- (SwordModule *)moduleForURL:(NSURL *)aUrl;

- (NSMutableArray *)swordModulesForFeature:(NSString *)feature;
- (NSMutableArray *)swordModulesForType:(NSString *)type;

#ifdef __cplusplus
- (id)initWithSWMgr:(sword::SWMgr *)smgr;
- (sword::SWModule *)getSWModuleWithName:(NSString *)moduleName;
- (sword::SWMgr *)swMgr;
#endif

@end

@interface NSDictionary (sortModules)
- (NSComparisonResult)sortModulesByTypeLanguageDescription:(NSDictionary *)aDictionary;
@end
