/*	SwordDict.h - Sword API wrapper for lexicons and Dictionaries.

	Copyright 2003 Will Thimbleby (wjt100@york.ac.uk)
	Based on code by Nathan Youngman (http://www.nathany.com)

	This program is free software; you can redistribute it and/or modify it under the terms of the
	GNU General Public License as published by the Free Software Foundation version 2.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
	even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
	General Public License for more details. (http://www.gnu.org/licenses/gpl.html)
*/

#import <Cocoa/Cocoa.h>
#import "SwordModule.h"

@class SwordModule;

@interface SwordDictionary : SwordModule
{
	NSMutableArray *entries;
    int numberOfEntries;
}

- (id)initWithSwordManager:(SwordManager *)theManager moduleName:(NSString*)name;
- (NSString *)fullRefName:(NSString*)ref;
- (NSMutableArray *)getEntries;
- (long)entryCount;
- (BOOL)hasReference:(NSString*)ref;

- (void)openCache;
- (void)saveCache;

- (NSString *)htmlForRef:(NSString *)reference embelish:(BOOL)embelish;
- (NSString *)htmlForRef:(NSString *)reference embelish:(BOOL)embelish protocol:(NSURLProtocol*)protocol;

@end
