/*	SwordCommentary.mm - Sword API wrapper for Commentaries.

	$Id: SwordCommentary.m,v 1.4 2006/02/02 00:20:07 willthimbleby Exp $

	Copyright 2003 Will Thimbleby (will@thimbleby.net)

	This program is free software; you can redistribute it and/or modify it under the terms of the
	GNU General Public License as published by the Free Software Foundation version 2.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
	even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
	General Public License for more details. (http://www.gnu.org/licenses/gpl.html)
*/

#import "SwordCommentary.h"
#import "utils.h"

// Well this is pretty much an empty sub-class of SwordBible
@implementation SwordCommentary

- (id)initWithSwordManager: (SwordManager *)theManager moduleName:(NSString*)name
{
	return [super initWithSwordManager:theManager moduleName:name];
}

- (NSString *)htmlForRef:(NSString *)reference embelish:(BOOL)embelish
{
	return [self htmlForRef:reference embelish:YES highlight:NO highlightReference:NULL];
}

- (NSString *)htmlForRef:(NSString *)reference embelish:(BOOL)embelish protocol:(NSURLProtocol*)protocol
{
	return [self htmlForRef:reference embelish:YES highlight:NO highlightReference:NULL protocol:protocol];
}


@end
