/*	SwordBible.h - Sword API wrapper for Biblical Texts.

	Copyright 2003 Will Thimbleby (wjt100@york.ac.uk)
	Based on code by Nathan Youngman (http://www.nathany.com)

	This program is free software; you can redistribute it and/or modify it under the terms of the
	GNU General Public License as published by the Free Software Foundation version 2.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
	even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
	General Public License for more details. (http://www.gnu.org/licenses/gpl.html)
*/

#import <Cocoa/Cocoa.h>
#import "SwordModule.h"

@class SwordModule;

typedef enum
{
	OldTestament,
	NewTestament
}Testament;

@interface SwordBible : SwordModule
{
	NSMutableArray *books;
    NSMutableArray *engBookNames;
    NSMutableArray *bookNumbers;
}

- (id)initWithSwordManager:(SwordManager *)theManager moduleName:(NSString*)name;
- (void)dealloc;

- (BOOL)hasReference:(NSString*)ref;
+ (void)decodeRef:(NSString*)ref intoBook:(NSString**)book chapter:(int*)chapter verse:(int*)verse;
+ (NSString*)firstRefName:(NSString*)abbr;
+ (NSString*)fullRefName:(NSString*)abbr;
- (void)book:(int*)book andChapter:(int*)chapter fromReference:(NSString*)ref;
+ (NSString*) context:(NSString*)abbr;

- (NSMutableArray *)bookNames;
- (NSMutableArray *)engBookNames;
- (void)getBookNames;
- (int)maxChaptersForBookName:(NSString *)bookName;
- (int)maxVersesForChapter:(int)chapter bookName:(NSString *)bookName;
- (long)entryCount;
/**
\brief calculate all verses for this bible book
 */
- (int)maxVersesForBible;

// Data retrieval
- (NSString *)entryForRef:(NSString *)reference;
- (NSString *)textForRef:(NSString *)reference;
- (NSString *)htmlForRef:(NSString *)reference;
- (NSString *)htmlForRef:(NSString *)reference embelish:(BOOL)embelish;
- (NSString *)htmlForRef:(NSString *)reference highlightReference:(NSString *)hr protocol:(SwordURLProtocol *)protocol;
- (NSString *)htmlForRef:(NSString *)reference 
				embelish:(BOOL)embelish 
			   highlight:(BOOL)highlight 
	  highlightReference:(NSString*)highlightRef;
- (NSString *)htmlForRef:(NSString *)reference 
				embelish:(BOOL)embelish 
			   highlight:(BOOL)highlight 
	  highlightReference:(NSString*)highlightRef 
				protocol:(SwordURLProtocol *)protocol;

+ (NSString *)parallel:(NSArray *)swordmodules 
			htmlForRef:(NSString *)reference 
			  embelish:(BOOL)embelish 
			 highlight:(BOOL)highlight 
	highlightReference:(NSString *)highlightRef;
+ (void)parallel:(NSArray *)swordmodules 
      htmlForRef:(NSString *)reference 
        embelish:(BOOL)embelish 
       highlight:(BOOL)highlight 
highlightReference:(NSString*)highlightRef 
        protocol:(SwordURLProtocol *)protocol;

- (void)writeEntry:(NSString*)value forRef:(NSString*)reference;

@end